"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConsumerRankingOptions = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const react_dnd_1 = require("react-dnd");
const react_dnd_html5_backend_1 = tslib_1.__importDefault(require("react-dnd-html5-backend"));
const RankingOptionElement_1 = require("./RankingOptionElement");
const utils_1 = require("./utils");
function getConsumerRankingOptions(nodeContent, formData, onRankingOptionSwapped, contentVarValues, variables, isForm) {
    return (react_1.default.createElement(react_dnd_1.DndProvider, { backend: react_dnd_html5_backend_1.default }, (formData.rankingOptions === null || formData.rankingOptions.length === 0
        ? nodeContent.options
        : formData.rankingOptions).map((option, index) => {
        const value = parseInt(option.index);
        const key = `dry-run-option-${value}`;
        const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(option, contentVarValues, variables);
        return (react_1.default.createElement(RankingOptionElement_1.RankingOptionElementSelector, { key: option.index, option: option, index: index, move: onRankingOptionSwapped, imageUrl: imageUrl, videoUrl: videoUrl, isOptionHoveringEnabled: nodeContent.isOptionHoveringEnabled }));
    })));
}
exports.getConsumerRankingOptions = getConsumerRankingOptions;
//# sourceMappingURL=getConsumerRankingOptions.js.map