"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConsumerSCQOptions = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const react_1 = tslib_1.__importDefault(require("react"));
const utils_1 = require("./utils");
const DarkTooltip_1 = require("./DarkTooltip");
const classNameUtils_1 = require("../../custom-classes-utils/classNameUtils");
function getConsumerSCQOptions(nodeContent, formData, onSCQOptionChanged, contentVarValues, variables, isForm, updateKeyMap) {
    const indexKeyboardShortcutBiMap = {};
    nodeContent.options.forEach((option, index) => {
        const shortCut = index <= 26 && !isForm ? String.fromCharCode(65 + index) : '';
        indexKeyboardShortcutBiMap[option.index] = shortCut;
        indexKeyboardShortcutBiMap[shortCut] = option.index;
        indexKeyboardShortcutBiMap[shortCut.toLowerCase()] = option.index;
    });
    updateKeyMap({
        SELECT_OPTION: (event) => {
            if ((event === null || event === void 0 ? void 0 : event.key) && indexKeyboardShortcutBiMap[event.key]) {
                onSCQOptionChanged(indexKeyboardShortcutBiMap[event.key]);
            }
        },
    });
    const optionClassName = classNameUtils_1.getClassnamesForOption(nodeContent);
    return (react_1.default.createElement(react_1.default.Fragment, null, nodeContent.optionDisplayType === models_1.OptionDisplayType.VERTICAL ? (react_1.default.createElement(core_1.RadioGroup, { value: formData.scqOption, onChange: (e, value) => onSCQOptionChanged(value) }, nodeContent.options.map((option, index) => {
        var _a;
        const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(option, contentVarValues, variables);
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(DarkTooltip_1.DarkTooltip, { title: nodeContent.isOptionHoveringEnabled
                    ? (_a = option.helperText) !== null && _a !== void 0 ? _a : '' : '', placement: "left", arrow: true },
                react_1.default.createElement("div", { style: { display: 'flex', alignItems: 'center' }, className: optionClassName },
                    indexKeyboardShortcutBiMap[option.index] && (react_1.default.createElement("div", { style: {
                            paddingLeft: 4,
                            paddingRight: 4,
                            margin: 4,
                            border: 'solid 2px black',
                            borderRadius: 2,
                            backgroundColor: 'rgb(119, 150, 254)',
                            fontWeight: 500,
                            height: 22,
                        } }, indexKeyboardShortcutBiMap[option.index])),
                    react_1.default.createElement(core_1.FormControlLabel, { value: parseInt(option.index), control: react_1.default.createElement(core_1.Radio, null), label: text, key: option.index }))),
            imageUrl && (react_1.default.createElement("div", null,
                react_1.default.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag."))));
    }))) : (react_1.default.createElement(core_1.Select, { inputProps: {
            selectInput: {
                padding: '8px 16px',
            },
        }, style: { maxWidth: 768 }, variant: 'outlined', className: optionClassName, value: formData.scqOption, renderValue: (selected) => { var _a, _b; return (_b = (_a = nodeContent.options.find((option) => option.index === `${selected}`)) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : ''; }, onChange: (event) => onSCQOptionChanged(event.target.value) }, nodeContent.options.map((item) => {
        const { text, imageUrl, videoUrl } = utils_1.getSubstitutedTextAndImage(item, contentVarValues, variables);
        return (react_1.default.createElement(core_1.MenuItem, { value: parseInt(item.index), key: item.index },
            text,
            imageUrl && (react_1.default.createElement("div", null,
                react_1.default.createElement("img", { src: imageUrl, style: { width: 320 } }))),
            videoUrl && (react_1.default.createElement("video", { width: "320", height: "240", controls: true, style: { margin: 'auto', border: '1px solid white' } },
                react_1.default.createElement("source", { src: videoUrl, type: "video/mp4" }),
                "Your browser does not support the video tag."))));
    })))));
}
exports.getConsumerSCQOptions = getConsumerSCQOptions;
//# sourceMappingURL=getConsumerSCQOptions.js.map