"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVariablesUI = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const core_1 = require("@material-ui/core");
const pickers_1 = require("@material-ui/pickers");
const react_1 = tslib_1.__importDefault(require("react"));
const icons_1 = require("@material-ui/icons");
function getVariablesUI(formContextVariables, changeHandler, classes, questionnaireVariables) {
    return formContextVariables.map((variable, index) => {
        var _a, _b;
        const varConfig = questionnaireVariables.find((it) => it.variableName === variable.name);
        if (!varConfig) {
            return null;
        }
        let strValue = '';
        let numValue = 0;
        let stringListValue = [];
        let numberListValue = [];
        if (variable.name) {
            switch (variable.variableType) {
                case models_1.VariableType.DOUBLE:
                    numValue = variable.number;
                    break;
                case models_1.VariableType.STRING:
                    strValue = variable.string;
                    break;
                case models_1.VariableType.LIST_STRING:
                    stringListValue = variable.stringsList;
                    break;
                case models_1.VariableType.LIST_DOUBLE:
                    numberListValue = variable.numbersList;
                    break;
            }
        }
        const options = (_b = (_a = varConfig.categoryValues) === null || _a === void 0 ? void 0 : _a.filter((it) => it)) !== null && _b !== void 0 ? _b : [];
        const hasOptions = options && options.length > 0;
        return (react_1.default.createElement("div", { key: variable.name, className: 'py-2 flex items-center gap-4 ' },
            react_1.default.createElement("span", { className: 'w-1/2' }, varConfig.displayVariableName),
            hasOptions && (react_1.default.createElement(core_1.Select, { variant: 'outlined', value: strValue, className: 'w-1/2', onChange: (e) => {
                    var _a;
                    const value = e.target.value;
                    changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.STRING,
                        string: value,
                    }, index);
                } }, options.map((option) => {
                return (react_1.default.createElement(core_1.MenuItem, { key: option, value: option }, option));
            }))),
            (varConfig.variableType === models_1.ContextVariableType.STRING ||
                varConfig.variableType === models_1.ContextVariableType.IMAGE ||
                varConfig.variableType === models_1.ContextVariableType.VIDEO) && (react_1.default.createElement(core_1.TextField, { variant: 'outlined', className: 'w-1/2', inputProps: { className: classes.rowInput }, type: 'text', value: strValue, onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.STRING,
                        string: e.target.value,
                    }, index);
                } })),
            (varConfig.variableType === models_1.ContextVariableType.INTEGER ||
                varConfig.variableType === models_1.ContextVariableType.REAL) && (react_1.default.createElement(core_1.TextField, { variant: 'outlined', className: 'w-1/2', inputProps: { className: classes.rowInput }, type: 'number', value: numValue, onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.DOUBLE,
                        number: parseFloat(e.target.value),
                    }, index);
                } })),
            varConfig.variableType === models_1.ContextVariableType.BOOLEAN && (react_1.default.createElement(core_1.Select, { variant: 'outlined', value: strValue, inputProps: { className: classes.rowInput }, className: 'w-1/2', onChange: (e) => {
                    var _a;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.STRING,
                        string: e.target.value,
                    }, index);
                } },
                react_1.default.createElement(core_1.MenuItem, { value: 'true' }, "Yes"),
                react_1.default.createElement(core_1.MenuItem, { value: 'false' }, "No"))),
            varConfig.variableType === models_1.ContextVariableType.DATE && (react_1.default.createElement(pickers_1.DatePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'dd/MM/yyyy', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === models_1.ContextVariableType.TIME && (react_1.default.createElement(pickers_1.TimePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'HH:mm', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === models_1.ContextVariableType.DATE_TIME && (react_1.default.createElement(pickers_1.DateTimePicker, { autoOk: true, inputProps: { className: classes.rowInput }, variant: 'inline', inputVariant: 'outlined', className: 'w-1/2', format: 'dd/MM/yyyy HH:mm', value: numValue ? new Date(numValue) : null, onChange: (date) => {
                    var _a, _b;
                    return changeHandler({
                        name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                        variableType: models_1.VariableType.DOUBLE,
                        number: (_b = date === null || date === void 0 ? void 0 : date.getTime()) !== null && _b !== void 0 ? _b : 0,
                    }, index);
                } })),
            varConfig.variableType === models_1.ContextVariableType.LIST_STRING && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                stringListValue.map((value, fieldIndex) => {
                    var _a;
                    return (react_1.default.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: {
                                className: classes.rowInput,
                            }, value: (_a = stringListValue[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: models_1.VariableType.LIST_STRING,
                                    stringsList: stringListValue.map((it, index) => {
                                        if (index === fieldIndex) {
                                            return event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '');
                                        }
                                        return it;
                                    }),
                                }, index);
                            } }),
                        react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: models_1.VariableType.LIST_STRING,
                                    stringsList: stringListValue.filter((it, index) => index !== fieldIndex),
                                }, index);
                            } },
                            react_1.default.createElement(icons_1.Close, null)),
                        fieldIndex !== stringListValue.length - 1 && (react_1.default.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                react_1.default.createElement(core_1.Button, { onClick: () => {
                        var _a;
                        changeHandler({
                            name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                            variableType: models_1.VariableType.LIST_STRING,
                            stringsList: [...stringListValue, ''],
                        }, index);
                    }, variant: 'contained' },
                    react_1.default.createElement(icons_1.Add, null)),
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "]"))),
            (varConfig.variableType === models_1.ContextVariableType.LIST_INTEGER ||
                varConfig.variableType === models_1.ContextVariableType.LIST_REAL) && (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                numberListValue.map((value, fieldIndex) => {
                    var _a;
                    return (react_1.default.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: {
                                className: classes.rowInput,
                            }, type: 'number', value: (_a = numberListValue[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: models_1.VariableType.LIST_DOUBLE,
                                    numbersList: numberListValue.map((it, index) => {
                                        if (index === fieldIndex) {
                                            return varConfig.variableType ===
                                                models_1.ContextVariableType.LIST_INTEGER
                                                ? parseInt(event.target.value)
                                                : parseFloat(event.target.value);
                                        }
                                        return it;
                                    }),
                                }, index);
                            } }),
                        react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => {
                                var _a;
                                changeHandler({
                                    name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                                    variableType: models_1.VariableType.LIST_DOUBLE,
                                    numbersList: numberListValue.filter((it, index) => index !== fieldIndex),
                                }, index);
                            } },
                            react_1.default.createElement(icons_1.Close, null)),
                        fieldIndex !== numberListValue.length - 1 && (react_1.default.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                react_1.default.createElement(core_1.Button, { onClick: () => {
                        var _a;
                        changeHandler({
                            name: (_a = variable.name) !== null && _a !== void 0 ? _a : '',
                            variableType: models_1.VariableType.LIST_DOUBLE,
                            numbersList: [...numberListValue, 0],
                        }, index);
                    }, variant: 'contained' },
                    react_1.default.createElement(icons_1.Add, null)),
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "]")))));
    });
}
exports.getVariablesUI = getVariablesUI;
//# sourceMappingURL=getVariablesUI.js.map