"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSubstitutedTextAndImage = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const consumerUtils_1 = require("../../utils/consumerUtils");
const common_1 = require("@fashtag/common");
const moment_1 = tslib_1.__importDefault(require("moment"));
const { CONTENT_VARIABLE_REGEX } = common_1.constants;
function getSubstitutedTextAndImage(nodeContent, contentVarValues, variables) {
    const content = consumerUtils_1.getContentForEdit(nodeContent, variables);
    const text = content.text.replace(CONTENT_VARIABLE_REGEX, (match) => {
        var _a;
        const variableName = match.slice(2, match.length - 1);
        const varValue = contentVarValues[variableName];
        if (varValue) {
            const variable = variables.find((it) => it.variableName === variableName);
            const ms = parseInt(varValue.value, 10);
            const momentNotation = moment_1.default(new Date(ms));
            switch (variable === null || variable === void 0 ? void 0 : variable.variableType) {
                case models_1.ContextVariableType.DATE:
                    return momentNotation.format('DD/MM/yyyy');
                case models_1.ContextVariableType.TIME:
                    return momentNotation.format('HH:mm');
                case models_1.ContextVariableType.DATE_TIME:
                    return momentNotation.format('DD/MM/yyyy HH:mm');
            }
        }
        return (_a = varValue === null || varValue === void 0 ? void 0 : varValue.value) !== null && _a !== void 0 ? _a : variableName;
    });
    let imageUrl = undefined;
    let videoUrl = undefined;
    const imageConfig = content.imageConfig;
    if (imageConfig.imageUrl) {
        imageUrl = imageConfig.imageUrl;
    }
    else if (imageConfig.videoUrl) {
        videoUrl = imageConfig.videoUrl;
    }
    else if (imageConfig.imageVariable) {
        const varValue = contentVarValues[imageConfig.imageVariable];
        imageUrl = varValue === null || varValue === void 0 ? void 0 : varValue.value;
    }
    else if (imageConfig.videoVariable) {
        const varValue = contentVarValues[imageConfig.videoVariable];
        videoUrl = varValue === null || varValue === void 0 ? void 0 : varValue.value;
    }
    return { text, imageUrl, videoUrl };
}
exports.getSubstitutedTextAndImage = getSubstitutedTextAndImage;
//# sourceMappingURL=utils.js.map