"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClassnamesForOption = exports.getClassnamesForWelThxBtn = exports.getClassnamesForDescription = exports.getClassnamesForContent = void 0;
const models_1 = require("@fashtag/common/dist/models");
const classes_1 = require("./classes");
function getClassnamesForContent(content) {
    const classes = [classes_1.StylingClasses.general.title];
    switch (content.nodeType) {
        case models_1.NodeType.STATEMENT:
            classes.push(classes_1.StylingClasses.statement.statement);
            break;
        case models_1.NodeType.QUESTION:
            classes.push(classes_1.StylingClasses.question.question);
            switch (content.questionType) {
                case models_1.QuestionType.SIGNATURE:
                    classes.push(classes_1.StylingClasses.signature.signatureTitle);
                    break;
                case models_1.QuestionType.RATING:
                    classes.push(classes_1.StylingClasses.rating.ratingQuestion);
                    break;
                case models_1.QuestionType.OPTIONS:
                    switch (content.optionType) {
                        case models_1.OptionType.SINGLE:
                            classes.push(classes_1.StylingClasses.options.scqQuestion);
                            break;
                        case models_1.OptionType.MULTIPLE:
                            classes.push(classes_1.StylingClasses.options.mcqQuestion);
                            break;
                        case models_1.OptionType.RANKING:
                            classes.push(classes_1.StylingClasses.options.rankingQuestion);
                            break;
                    }
                    break;
                case models_1.QuestionType.TEXT:
                    if (content.qualitativeType === models_1.QualitativeType.UPLOAD) {
                        classes.push(classes_1.StylingClasses.upload.uploadTitle);
                    }
                    else {
                        classes.push(classes_1.StylingClasses.qualitative.qualitativeQuestion);
                    }
                    break;
                case models_1.QuestionType.MATRIX:
                    classes.push(classes_1.StylingClasses.matrix.matrixQuestion);
                    break;
                case models_1.QuestionType.UX:
                    classes.push(classes_1.StylingClasses.ux.uxTitle);
                    break;
            }
            break;
        case models_1.NodeType.THANKS:
            classes.push(classes_1.StylingClasses.thanksBlock.thanksTitle);
            break;
        case models_1.NodeType.WELCOME:
            classes.push(classes_1.StylingClasses.welcomeBlock.welcomeTitle);
            break;
    }
    return classes.join(' ');
}
exports.getClassnamesForContent = getClassnamesForContent;
function getClassnamesForDescription(content) {
    const classes = [classes_1.StylingClasses.general.desc];
    if (content.nodeType === models_1.NodeType.WELCOME) {
        classes.push(classes_1.StylingClasses.welcomeBlock.welcomeDesc);
    }
    if (content.nodeType === models_1.NodeType.THANKS) {
        classes.push(classes_1.StylingClasses.thanksBlock.thanksDesc);
    }
    if (content.nodeType === models_1.NodeType.QUESTION) {
        if (content.questionType === models_1.QuestionType.SIGNATURE)
            classes.push(classes_1.StylingClasses.signature.signatureDesc);
        else if (content.questionType === models_1.QuestionType.UX)
            classes.push(classes_1.StylingClasses.ux.uxDesc);
    }
    return classes.join(' ');
}
exports.getClassnamesForDescription = getClassnamesForDescription;
function getClassnamesForWelThxBtn(content) {
    const classes = [classes_1.StylingClasses.general.btn];
    switch (content.nodeType) {
        case models_1.NodeType.WELCOME:
            classes.push(classes_1.StylingClasses.welcomeBlock.welcomeBtn);
            break;
        case models_1.NodeType.THANKS:
            classes.push(classes_1.StylingClasses.thanksBlock.thanksBtn);
            break;
    }
    return classes.join(' ');
}
exports.getClassnamesForWelThxBtn = getClassnamesForWelThxBtn;
function getClassnamesForOption(content) {
    const classes = [];
    switch (content.questionType) {
        case models_1.QuestionType.OPTIONS:
            switch (content.optionType) {
                case models_1.OptionType.SINGLE:
                    if (content.optionDisplayType === models_1.OptionDisplayType.VERTICAL) {
                        classes.push(classes_1.StylingClasses.options.scqOption);
                        classes.push(classes_1.StylingClasses.question.option);
                    }
                    else {
                        classes.push(classes_1.StylingClasses.options.scqDropdown);
                        classes.push(classes_1.StylingClasses.question.dropdown);
                    }
                    break;
                case models_1.OptionType.MULTIPLE:
                    if (content.optionDisplayType === models_1.OptionDisplayType.VERTICAL) {
                        classes.push(classes_1.StylingClasses.options.mcqOption);
                        classes.push(classes_1.StylingClasses.question.option);
                    }
                    else {
                        classes.push(classes_1.StylingClasses.options.mcqDropdown);
                        classes.push(classes_1.StylingClasses.question.dropdown);
                    }
                    break;
                case models_1.OptionType.RANKING:
                    classes.push(classes_1.StylingClasses.options.rankingOption);
                    classes.push(classes_1.StylingClasses.question.option);
                    break;
            }
            break;
        case models_1.QuestionType.RATING:
            classes.push(classes_1.StylingClasses.rating.ratingOption);
            classes.push(classes_1.StylingClasses.question.option);
            switch (content.ratingDisplayType) {
                case models_1.RatingDisplayType.NUMERIC:
                    classes.push(classes_1.StylingClasses.rating.ratingOptionNumber);
                    break;
                case models_1.RatingDisplayType.THUMBS_UP:
                    classes.push(classes_1.StylingClasses.rating.ratingOptionThumbsUp);
                    break;
                case models_1.RatingDisplayType.PEOPLE:
                    classes.push(classes_1.StylingClasses.rating.ratingOptionReaction);
                    break;
                case models_1.RatingDisplayType.LIGHTNING:
                    classes.push(classes_1.StylingClasses.rating.ratingOptionLightning);
                    break;
                case models_1.RatingDisplayType.STARS:
                    classes.push(classes_1.StylingClasses.rating.ratingOptionStars);
                    break;
            }
            break;
    }
    return classes.join(' ');
}
exports.getClassnamesForOption = getClassnamesForOption;
//# sourceMappingURL=classNameUtils.js.map