"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unloadQuestionnaireWebSDK = exports.loadQuestionnaireWebSDK = exports.ConsumerWebSDK = exports.Consumer = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const common_1 = require("@fashtag/common");
const ConsumerRootStore_1 = require("./stores/ConsumerRootStore");
const ConsumerWrapper_1 = require("./components/ConsumerWrapper");
const ConsumerWebSDK_1 = require("./components/ConsumerWebSDK");
const react_dom_1 = tslib_1.__importDefault(require("react-dom"));
require("./tailwind/output.css");
const providedConsumerWrapper = common_1.provideStore(ConsumerRootStore_1.ConsumerRootStore, ConsumerWrapper_1.ConsumerWrapper);
exports.Consumer = providedConsumerWrapper;
const ProvidedConsumerSDK = common_1.provideStore(ConsumerRootStore_1.ConsumerRootStore, ConsumerWebSDK_1.ConsumerWebSDK);
exports.ConsumerWebSDK = ProvidedConsumerSDK;
function loadQuestionnaireWebSDK(container, data, onExit, apiKey) {
    react_dom_1.default.render(react_1.default.createElement(ProvidedConsumerSDK, { onExit: () => {
            onExit();
        }, initData: data, apiKey: apiKey }), container);
}
exports.loadQuestionnaireWebSDK = loadQuestionnaireWebSDK;
function unloadQuestionnaireWebSDK(container) {
    react_dom_1.default.unmountComponentAtNode(container);
}
exports.unloadQuestionnaireWebSDK = unloadQuestionnaireWebSDK;
tslib_1.__exportStar(require("./models/ConsumerModels"), exports);
//# sourceMappingURL=index.js.map