import { ContentVarValueData, FlowType, QuestionnaireEmbedSessionDTO, QuestionnareResponseDTO, VariableData, Option, DistributionType } from '@fashtag/common/dist/models';
import { AudioRecordingData, ImageRecordingData, VideoRecordingData } from '@fashtag/common';
export declare type ConsumerValidVarConfig = {
    name: string;
} & VariableData;
export declare type ConsumerVarConfig = ConsumerValidVarConfig | {
    name: undefined;
};
export declare enum ConsumerMode {
    DRY_RUN = "DRY_RUN",
    WEB_CONSUMER = "WEB_CONSUMER",
    SDK_CONSUMER = "SDK_CONSUMER",
    UNIVERSE = "UNIVERSE"
}
export interface QuestionnaireConsumerContext {
    id?: string;
    flowType: FlowType;
    questionnareId: string;
    workspaceId: string;
    context: Record<string, VariableData>;
    allContentVarsValues: Record<string, ContentVarValueData>;
}
export interface UniverseQuestionnaireConsumerContext {
    flowType: FlowType;
    storeAssociateId: string;
    storeId: string;
    workspaceId: string;
}
export declare enum ConsumerState {
    NOT_RUNNING = 0,
    VARIABLE_SELECTION = 1,
    RUNNING = 2,
    FINISHED = 3
}
export interface WebConsumerData {
    questionnaireId?: string;
    workspaceId: string;
    flowType: FlowType;
    mode: ConsumerMode.DRY_RUN | ConsumerMode.WEB_CONSUMER;
    distributionType?: DistributionType;
    questionnaireDTO?: QuestionnareResponseDTO;
    futureSessionId?: string;
}
export interface UniverseConsumerData {
    questionnaireId: string;
    workspaceId: string;
    flowType: FlowType;
    mode: ConsumerMode.UNIVERSE;
    storeId: string;
    storeAssociateId: string;
    questionnaireDTO?: QuestionnareResponseDTO;
}
export interface SDKConsumerData {
    mode: ConsumerMode.SDK_CONSUMER;
    initData: QuestionnaireEmbedSessionDTO;
}
export declare type ConsumerData = WebConsumerData | SDKConsumerData | UniverseConsumerData;
export interface AnswerObject {
    answer?: VariableData;
    url?: string;
    imageUrl?: string;
    videoUrl?: string;
    dateResponse?: string;
    timeResponse?: string;
    matrixResponse?: Record<string, VariableData>;
    responseMetadata?: Record<string, string>;
}
export interface QuestionnaireConsumerFormData {
    scqOption: number;
    mcqOptions: number[];
    matrixOptions: Record<string, number[]>;
    rankingOptions: Option[];
    text: string;
    rating: number;
    fileUpload: File | null;
    formQuestions?: QuestionnaireConsumerFormData[];
    audioRecordingData: AudioRecordingData | null;
    videoRecordingData: VideoRecordingData | null;
    imageRecordingData: ImageRecordingData | null;
    date: Date | null;
    time: Date | null;
    uxTextResponse: string;
    uxXPathResponse: string;
    uxUserVideoResponse: VideoRecordingData | null;
    uxUserImageResponse: ImageRecordingData | null;
}
