import { FeedBackResponseDTO, FlowType, QuestionResponseDTO } from '@fashtag/common/dist/models';
import { QuestionnaireConsumerContext, SDKConsumerData, UniverseQuestionnaireConsumerContext, WebConsumerData } from '../models/ConsumerModels';
export declare class QuestionnaireConsumerService {
    navigateBack(sessionId: string, flowType: FlowType): Promise<QuestionResponseDTO>;
    navigateForward(sessionId: string, flowType: FlowType): Promise<QuestionResponseDTO>;
    startDryRun(input: QuestionnaireConsumerContext): Promise<QuestionResponseDTO>;
    startUniverseQuestionnaire(input: UniverseQuestionnaireConsumerContext, flowType: FlowType, qId: string): Promise<QuestionResponseDTO>;
    startWebConsumer(consumerData: WebConsumerData): Promise<QuestionResponseDTO>;
    startSDKConsumer(consumerData: SDKConsumerData): Promise<QuestionResponseDTO>;
    getDryRunNextQuestion(input: FeedBackResponseDTO): Promise<QuestionResponseDTO>;
    exitQuestionnaire(input: FeedBackResponseDTO): Promise<QuestionResponseDTO>;
    getWebConsumerNextQuestion(input: FeedBackResponseDTO): Promise<QuestionResponseDTO>;
    getSDKConsumerNextQuestion(input: FeedBackResponseDTO): Promise<QuestionResponseDTO>;
    getUniverseQuestionnaireNextQuestion(flowType: FlowType, input: FeedBackResponseDTO): Promise<QuestionResponseDTO>;
}
