"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QuestionnaireConsumerService = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@fashtag/common");
const models_1 = require("@fashtag/common/dist/models");
const urls_1 = require("../urls");
class QuestionnaireConsumerService {
    // async getEditQuestionnaireData(
    //   businessId: string,
    //   questionnaireId: string,
    //   signal?: AbortSignal
    // ): Promise<QuestionnareResponseDTO> {
    //   const url = urls.getEditQuestionnaireData(businessId, questionnaireId);
    //   return http.get(url, { signal });
    // }
    navigateBack(sessionId, flowType) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const url = urls_1.urls.navigateBack(sessionId, flowType);
            return common_1.http.get(url);
        });
    }
    navigateForward(sessionId, flowType) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const url = urls_1.urls.navigateForward(sessionId, flowType);
            return common_1.http.get(url);
        });
    }
    startDryRun(input) {
        const url = urls_1.urls.startDryRun();
        return common_1.http.post(url, input);
    }
    startUniverseQuestionnaire(input, flowType, qId) {
        const url = urls_1.urls.startUniverseQuestionnaire(flowType, qId);
        return common_1.http.post(url, input);
    }
    startWebConsumer(consumerData) {
        const url = urls_1.urls.startSDKConsumer();
        return common_1.http
            .post(url, {
            flowType: consumerData.flowType,
            questionnaireId: consumerData.questionnaireId,
            distributionType: consumerData.distributionType,
            isDryRun: false,
            sessionStatus: models_1.SessionStatus.CREATED,
            context: {},
            allContentVarsValues: {},
            futureSessionId: consumerData.futureSessionId,
        }, { parseJSON: false })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
    startSDKConsumer(consumerData) {
        const url = urls_1.urls.startSDKConsumer();
        return common_1.http
            .post(url, consumerData.initData, {
            parseJSON: false,
        })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getDryRunNextQuestion(input) {
        const url = urls_1.urls.getDryRunNextQuestion();
        return common_1.http
            .post(url, input, { parseJSON: false })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
    exitQuestionnaire(input) {
        const url = urls_1.urls.exitQuestionnaire();
        return common_1.http.post(url, input, {
            parseJSON: false,
        });
    }
    getWebConsumerNextQuestion(input) {
        const url = urls_1.urls.getWebConsumerNextQuestion();
        return common_1.http
            .post(url, input, { parseJSON: false })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getSDKConsumerNextQuestion(input) {
        const url = urls_1.urls.getSDKConsumerNextQuestion();
        return common_1.http
            .post(url, input, { parseJSON: false })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
    getUniverseQuestionnaireNextQuestion(flowType, input) {
        const url = urls_1.urls.getUniverseQuestionnaireNextQuestion(flowType);
        return common_1.http
            .post(url, input, { parseJSON: false })
            .then((response) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (response.status !== 204) {
                try {
                    return yield response.json();
                }
                catch (e) {
                    return {
                        sessionStatus: models_1.SessionStatus.COMPLETED,
                    };
                }
            }
            else {
                return {
                    sessionStatus: models_1.SessionStatus.COMPLETED,
                };
            }
        }));
    }
}
exports.QuestionnaireConsumerService = QuestionnaireConsumerService;
//# sourceMappingURL=QuestionnaireConsumerService.js.map