import { AudioRecordingData, Destructible, ImageRecordingData, VideoRecordingData } from '@fashtag/common';
import { ChatDistributionSettings, DisplayPosition, DisplayStyle, DisplayType, FormItem, NetworkError, NetworkResponse, OptionType, QuestionnareResponseDTO, QuestionResponseDTO } from '@fashtag/common/dist/models';
import { IReactionDisposer } from 'mobx';
import { ConsumerData, ConsumerState, ConsumerValidVarConfig, ConsumerVarConfig, QuestionnaireConsumerFormData } from '..';
import { QuestionnaireConsumerService } from '../services/QuestionnaireConsumerService';
export interface DisplayConfig {
    displayType?: DisplayType;
    displayPosition?: DisplayPosition;
    displayAfterTime?: number;
    webURLMatchesString?: string;
    webScrollTillPercentage?: number;
    displayStyle?: DisplayStyle;
    chatDistributionSettings?: ChatDistributionSettings;
}
export declare class ConsumerStore implements Destructible {
    private questionnaireConsumerService;
    consumerState: ConsumerState;
    consumerData: ConsumerData | undefined;
    question: QuestionResponseDTO | null;
    get customCSS(): string;
    isQuestionLoading: boolean;
    error: NetworkError | null;
    formData: QuestionnaireConsumerFormData;
    contextVars: Array<ConsumerVarConfig>;
    contentVars: Array<ConsumerVarConfig>;
    existingElements: QuestionResponseDTO[];
    existingElementsAnswer: Array<string>;
    displayConfig: DisplayConfig;
    keyMapHandler: {
        [key: string]: (keyEvent?: KeyboardEvent) => void;
    };
    questionnaireResponse: NetworkResponse<QuestionnareResponseDTO>;
    get isRunning(): boolean;
    updateKeyMap: (newKeyMap: {
        [key: string]: (keyEvent?: KeyboardEvent | undefined) => void;
    }) => void;
    addToExistingElements: (element: QuestionResponseDTO) => void;
    addToExistingElementsAnswer: (string: string) => void;
    resetConsumer: () => void;
    initiateConsumer: (consumerData: ConsumerData) => void;
    onNextQuestion: (question: QuestionResponseDTO | null, isLoading: boolean, error: NetworkError | null) => void;
    private applyNextQuestionPromise;
    setAnswersOnRevisit: (question: QuestionResponseDTO) => void;
    navigateBack: (sessionId: string) => void;
    private prefillResponses;
    navigateForward: (sessionId: string) => void;
    getFirstQuestion: () => Promise<void>;
    private startDryRun;
    getNextQuestion: (isSkip?: boolean) => Promise<void>;
    skipQuestion: () => Promise<void>;
    nextQuestion: () => Promise<void>;
    closeConsumer: (finishedSuccessfully?: boolean) => void;
    onSCQOptionChanged: (value: string) => void;
    toggleMCQOption: (value: number) => void;
    setMCQOptions: (indices: number[]) => void;
    setMatrixOptions: (rowIndex: string, value: number, optionType: OptionType) => void;
    onRankingOptionSwapped: (from: number, to: number) => void;
    onTextChange: (text: string) => void;
    onRatingChange: (rating: number) => void;
    onAudioRecordingChanged: (data: AudioRecordingData | null) => void;
    onFileChanged: (file: File | null) => void;
    onVideoRecordingChanged: (data: VideoRecordingData | null) => void;
    onImageRecordingChanged: (data: ImageRecordingData | null) => void;
    onDateChanged: (date: Date | null) => void;
    onUXPathResponseChanged: (data: string | null) => void;
    onUXTextResponseChanged: (data: string | null) => void;
    onUXUserVideoResponseChanged: (data: VideoRecordingData | null) => void;
    onUXUserImageResponseChanged: (data: ImageRecordingData | null) => void;
    onTimeChanged: (date: Date | null) => void;
    onFormQuestionsChange: (questions: QuestionnaireConsumerFormData[]) => void;
    initializeFormQuestions: (formItems: FormItem[]) => void;
    private getVarConfig;
    changeContextVarValue: (config: ConsumerValidVarConfig, index: number) => void;
    changeContentVarValue: (config: ConsumerValidVarConfig, index: number) => void;
    addReactions(): void;
    private addQuestionnaireReaction;
    abortControllers: Map<string, AbortController>;
    reactionDisposers: IReactionDisposer[];
    constructor(questionnaireConsumerService: QuestionnaireConsumerService);
    destructor(): void;
}
