"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.urls = void 0;
const common_1 = require("@fashtag/common");
const { questionnaireBaseUrl, fashtagBaseUrl, questionnaireConsumerBaseUrl } = common_1.baseUrls;
exports.urls = {
    // getEditQuestionnaireData: (businessId: string, questionnaireId: string) => `
    //   ${questionnaireBaseUrl}/questions/questionnare/${questionnaireId}`,
    // Dry-run APIs. Used as embedded in builder
    startDryRun: () => `${questionnaireConsumerBaseUrl}/dry-run/start-dry-run`,
    getDryRunNextQuestion: () => `${questionnaireConsumerBaseUrl}/dry-run/nextquestion`,
    // Consumer APIs.
    navigateBack: (sessionId, flowType) => `
    ${questionnaireBaseUrl}/consumer/navigate-back/session/${sessionId}/flow-type/${flowType}`,
    navigateForward: (sessionId, flowType) => `
    ${questionnaireBaseUrl}/consumer/navigate-forward/session/${sessionId}/flow-type/${flowType}`,
    startUniverseQuestionnaire: (flow, qId) => `${questionnaireConsumerBaseUrl}/consumer/firstquestion/${flow.toLowerCase()}/${qId}`,
    getUniverseQuestionnaireNextQuestion: (flow) => `${questionnaireConsumerBaseUrl}/consumer/nextquestion/${flow.toLowerCase()}`,
    getWebConsumerNextQuestion: () => `${questionnaireConsumerBaseUrl}/consumer/nextquestion`,
    startSDKConsumer: () => `${questionnaireConsumerBaseUrl}/consumer/firstquestion-embed`,
    getSDKConsumerNextQuestion: () => `${questionnaireConsumerBaseUrl}/consumer/nextquestion`,
    exitQuestionnaire: () => `${questionnaireBaseUrl}/consumer/exitQuestionnaire`,
};
//# sourceMappingURL=urls.js.map