"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getContent = exports.isVariableValid = exports.getFormAnswer = exports.getAnswer = exports.getFormAnswerForChat = exports.getAnswerForChat = exports.isSignatureResponseTypeAllowed = exports.isResponseTypeAllowed = exports.getEmptyQuestionnaireConsumerData = exports.getContentForEdit = void 0;
const tslib_1 = require("tslib");
const models_1 = require("@fashtag/common/dist/models");
const common_1 = require("@fashtag/common");
function getContentForEdit(nodeContent, variables) {
    var _a, _b, _c, _d, _e, _f, _g;
    let text = (_a = nodeContent.content) !== null && _a !== void 0 ? _a : '';
    const imageVariable = (_d = (_c = (_b = text
        .match(common_1.constants.CONTENT_VARIABLE_REGEX)) === null || _b === void 0 ? void 0 : _b.map((it) => it.slice(2, it.length - 1))) === null || _c === void 0 ? void 0 : _c.find((it) => {
        const varConfig = variables.find((variable) => variable.variableName === it);
        return (varConfig === null || varConfig === void 0 ? void 0 : varConfig.variableType) === models_1.ContextVariableType.IMAGE;
    })) !== null && _d !== void 0 ? _d : '';
    const videoVariable = (_g = (_f = (_e = text
        .match(common_1.constants.CONTENT_VARIABLE_REGEX)) === null || _e === void 0 ? void 0 : _e.map((it) => it.slice(2, it.length - 1))) === null || _f === void 0 ? void 0 : _f.find((it) => {
        const varConfig = variables.find((variable) => variable.variableName === it);
        return (varConfig === null || varConfig === void 0 ? void 0 : varConfig.variableType) === models_1.ContextVariableType.VIDEO;
    })) !== null && _g !== void 0 ? _g : '';
    if (imageVariable) {
        text = text.replace(`<#${imageVariable}>`, '');
    }
    if (videoVariable) {
        text = text.replace(`<#${videoVariable}>`, '');
    }
    const imageUrl = nodeContent.imageUrl;
    const videoUrl = nodeContent.videoUrl;
    return {
        text,
        imageConfig: {
            imageUrl,
            imageVariable,
            videoVariable,
            videoUrl,
        },
    };
}
exports.getContentForEdit = getContentForEdit;
function getEmptyQuestionnaireConsumerData(rankingOption) {
    return {
        scqOption: -1,
        mcqOptions: [],
        rankingOptions: rankingOption !== null && rankingOption !== void 0 ? rankingOption : [],
        matrixOptions: {},
        text: '',
        fileUpload: null,
        rating: -1,
        audioRecordingData: null,
        videoRecordingData: null,
        imageRecordingData: null,
        date: null,
        time: null,
        uxTextResponse: '',
        uxUserVideoResponse: null,
        uxXPathResponse: '',
        uxUserImageResponse: null,
    };
}
exports.getEmptyQuestionnaireConsumerData = getEmptyQuestionnaireConsumerData;
function isResponseTypeAllowed(nodeContent, type) {
    return nodeContent.allowedResponseTypes.includes(type);
}
exports.isResponseTypeAllowed = isResponseTypeAllowed;
function isSignatureResponseTypeAllowed(nodeContent, type) {
    return nodeContent.signatureAllowedResponseTypes.includes(type);
}
exports.isSignatureResponseTypeAllowed = isSignatureResponseTypeAllowed;
function getTextAnswerObj(nodeContent, questionnaireConsumerFormData) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const textAnswerObj = {};
        if (nodeContent.qualitativeType === models_1.QualitativeType.UPLOAD && (questionnaireConsumerFormData === null || questionnaireConsumerFormData === void 0 ? void 0 : questionnaireConsumerFormData.fileUpload)) {
            const response = yield common_1.UtilityService.uploadFile(questionnaireConsumerFormData === null || questionnaireConsumerFormData === void 0 ? void 0 : questionnaireConsumerFormData.fileUpload, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            textAnswerObj.url = response.url;
            return textAnswerObj;
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.TEXT_RESPONSE)) {
            textAnswerObj.answer = {
                variableType: models_1.VariableType.STRING,
                string: questionnaireConsumerFormData.text,
            };
        }
        let audioPromise;
        let videoPromise;
        let imagePromise;
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.AUDIO_RESPONSE)) {
            const audioBlob = (_a = questionnaireConsumerFormData.audioRecordingData) === null || _a === void 0 ? void 0 : _a.audioBlob;
            if (audioBlob) {
                const recordingFile = new File([audioBlob], 'recording.wav');
                audioPromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            }
            if ((_b = questionnaireConsumerFormData.audioRecordingData) === null || _b === void 0 ? void 0 : _b.audioUrl) {
                textAnswerObj.url = (_c = questionnaireConsumerFormData.audioRecordingData) === null || _c === void 0 ? void 0 : _c.audioUrl;
            }
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.VIDEO_RESPONSE)) {
            const videoBlob = (_d = questionnaireConsumerFormData.videoRecordingData) === null || _d === void 0 ? void 0 : _d.videoBlob;
            if (videoBlob) {
                const recordingFile = new File([videoBlob], 'recording.webm');
                videoPromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            }
            if ((_e = questionnaireConsumerFormData.videoRecordingData) === null || _e === void 0 ? void 0 : _e.videoUrl) {
                textAnswerObj.videoUrl = (_f = questionnaireConsumerFormData.videoRecordingData) === null || _f === void 0 ? void 0 : _f.videoUrl;
            }
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.IMAGE_RESPONSE)) {
            const imageBlob = (_g = questionnaireConsumerFormData.imageRecordingData) === null || _g === void 0 ? void 0 : _g.imageBlob;
            if (imageBlob) {
                const recordingFile = new File([imageBlob], 'recording.png');
                imagePromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            }
            if ((_h = questionnaireConsumerFormData.imageRecordingData) === null || _h === void 0 ? void 0 : _h.imageUrl) {
                textAnswerObj.imageUrl = (_j = questionnaireConsumerFormData.imageRecordingData) === null || _j === void 0 ? void 0 : _j.imageUrl;
            }
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.AUDIO_RESPONSE) &&
            audioPromise) {
            const response = yield audioPromise;
            textAnswerObj.url = response.url;
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.VIDEO_RESPONSE) &&
            videoPromise) {
            const response = yield videoPromise;
            textAnswerObj.videoUrl = response.url;
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.IMAGE_RESPONSE) &&
            imagePromise) {
            const response = yield imagePromise;
            textAnswerObj.imageUrl = response.url;
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.DATE_RESPONSE)) {
            const date = questionnaireConsumerFormData.date;
            if (date) {
                textAnswerObj.dateResponse = date.toISOString();
            }
        }
        if (isResponseTypeAllowed(nodeContent, models_1.AllowedResponseType.TIME_RESPONSE)) {
            const time = questionnaireConsumerFormData.time;
            if (time) {
                textAnswerObj.timeResponse = time.toISOString();
            }
        }
        return textAnswerObj;
    });
}
function srcToFile(src, fileName, mimeType) {
    return fetch(src)
        .then(function (res) {
        return res.arrayBuffer();
    })
        .then(function (buf) {
        return new File([buf], fileName, { type: mimeType });
    });
}
function getSignatureAnswerObj(nodeContent, questionnaireConsumerFormData) {
    var _a, _b, _c;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const textAnswerObj = {};
        let imagePromise;
        if (isSignatureResponseTypeAllowed(nodeContent, models_1.SignatureAllowedResponseType.TYPE) &&
            questionnaireConsumerFormData.text) {
            textAnswerObj.answer = {
                variableType: models_1.VariableType.STRING,
                string: questionnaireConsumerFormData.text,
            };
            return textAnswerObj;
        }
        if (isSignatureResponseTypeAllowed(nodeContent, models_1.SignatureAllowedResponseType.UPLOAD) && (questionnaireConsumerFormData === null || questionnaireConsumerFormData === void 0 ? void 0 : questionnaireConsumerFormData.fileUpload)) {
            const response = yield common_1.UtilityService.uploadFile(questionnaireConsumerFormData === null || questionnaireConsumerFormData === void 0 ? void 0 : questionnaireConsumerFormData.fileUpload, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            textAnswerObj.url = response.url;
            return textAnswerObj;
        }
        if (isSignatureResponseTypeAllowed(nodeContent, models_1.SignatureAllowedResponseType.DRAW)) {
            const imageDataURL = (_a = questionnaireConsumerFormData.imageRecordingData) === null || _a === void 0 ? void 0 : _a.imageDataURL;
            if (imageDataURL) {
                const recordingFile = yield srcToFile(imageDataURL, `recording.png`, 'image/png');
                imagePromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            }
            if ((_b = questionnaireConsumerFormData.imageRecordingData) === null || _b === void 0 ? void 0 : _b.imageUrl) {
                textAnswerObj.imageUrl = (_c = questionnaireConsumerFormData.imageRecordingData) === null || _c === void 0 ? void 0 : _c.imageUrl;
            }
        }
        if (isSignatureResponseTypeAllowed(nodeContent, models_1.SignatureAllowedResponseType.DRAW) &&
            imagePromise) {
            const response = yield imagePromise;
            textAnswerObj.imageUrl = response.url;
        }
        return textAnswerObj;
    });
}
function getUXAnswerObj(nodeContent, questionnaireConsumerFormData) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const answerObj = {};
        let imagePromise;
        let videoPromise;
        let audioPromise;
        const imageDataURL = (_a = questionnaireConsumerFormData.imageRecordingData) === null || _a === void 0 ? void 0 : _a.imageDataURL;
        if (imageDataURL) {
            const recordingFile = yield srcToFile(imageDataURL, `recording.png`, 'image/png');
            imagePromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            const response = yield imagePromise;
            answerObj.imageUrl = response.url;
        }
        if ((_b = questionnaireConsumerFormData.imageRecordingData) === null || _b === void 0 ? void 0 : _b.imageUrl) {
            answerObj.imageUrl = (_c = questionnaireConsumerFormData.imageRecordingData) === null || _c === void 0 ? void 0 : _c.imageUrl;
        }
        let responseMetadata = {};
        const imageDataURLExtra = (_d = questionnaireConsumerFormData.uxUserImageResponse) === null || _d === void 0 ? void 0 : _d.imageDataURL;
        if (imageDataURLExtra) {
            const recordingFile = yield srcToFile(imageDataURLExtra, `recording.png`, 'image/png');
            imagePromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            const response = yield imagePromise;
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxUserImageResponse: response.url });
        }
        if ((_e = questionnaireConsumerFormData.uxUserImageResponse) === null || _e === void 0 ? void 0 : _e.imageUrl) {
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxUserImageResponse: (_f = questionnaireConsumerFormData.uxUserImageResponse) === null || _f === void 0 ? void 0 : _f.imageUrl });
        }
        if ((_g = questionnaireConsumerFormData.audioRecordingData) === null || _g === void 0 ? void 0 : _g.audioUrl) {
            answerObj.url = questionnaireConsumerFormData.audioRecordingData.audioUrl;
        }
        else {
            const audioBlob = (_h = questionnaireConsumerFormData.audioRecordingData) === null || _h === void 0 ? void 0 : _h.audioBlob;
            if (audioBlob) {
                const recordingFile = new File([audioBlob], 'recording.wav');
                audioPromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
                const response = yield audioPromise;
                answerObj.url = response.url;
            }
        }
        if ((_j = questionnaireConsumerFormData.videoRecordingData) === null || _j === void 0 ? void 0 : _j.videoExternalUrl) {
            answerObj.videoUrl = (_k = questionnaireConsumerFormData.videoRecordingData) === null || _k === void 0 ? void 0 : _k.videoExternalUrl;
        }
        else {
            const videoBlob = (_l = questionnaireConsumerFormData.videoRecordingData) === null || _l === void 0 ? void 0 : _l.videoBlob;
            if (videoBlob) {
                const recordingFile = new File([videoBlob], 'recording.webm');
                videoPromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
                const response = yield videoPromise;
                answerObj.videoUrl = response.url;
            }
        }
        if (questionnaireConsumerFormData.uxTextResponse) {
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxTextResponse: questionnaireConsumerFormData.uxTextResponse });
        }
        const videoBlobExtra = (_m = questionnaireConsumerFormData.uxUserVideoResponse) === null || _m === void 0 ? void 0 : _m.videoBlob;
        if (videoBlobExtra) {
            const recordingFile = new File([videoBlobExtra], 'recording.webm');
            videoPromise = common_1.UtilityService.uploadFile(recordingFile, common_1.constants.QUESTIONNAIRE_BUCKET, common_1.UploadServiceType.QUESTIONNAIRE);
            const response = yield videoPromise;
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxUserVideoResponse: response.url });
        }
        if ((_o = questionnaireConsumerFormData.uxUserVideoResponse) === null || _o === void 0 ? void 0 : _o.videoUrl) {
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxUserVideoResponse: (_p = questionnaireConsumerFormData.uxUserVideoResponse) === null || _p === void 0 ? void 0 : _p.videoUrl });
        }
        if (questionnaireConsumerFormData.uxXPathResponse) {
            responseMetadata = Object.assign(Object.assign({}, responseMetadata), { uxXPathResponse: questionnaireConsumerFormData.uxXPathResponse });
        }
        answerObj.responseMetadata = responseMetadata;
        return answerObj;
    });
}
function getAnswerForChat(questionnaireConsumerFormData, nodeContent) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (nodeContent.nodeType === models_1.NodeType.QUESTION) {
            if (nodeContent.questionType === models_1.QuestionType.OPTIONS) {
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    return ((_b = (_a = nodeContent.options.find((option) => parseInt(option.index) === questionnaireConsumerFormData.scqOption)) === null || _a === void 0 ? void 0 : _a.content) !== null && _b !== void 0 ? _b : '');
                }
                else if (nodeContent.optionType === models_1.OptionType.MULTIPLE) {
                    return (_d = (_c = questionnaireConsumerFormData.mcqOptions) === null || _c === void 0 ? void 0 : _c.map((option) => { var _a; return (_a = nodeContent.options.find((innerOption) => parseInt(innerOption.index) === option)) === null || _a === void 0 ? void 0 : _a.content; })) === null || _d === void 0 ? void 0 : _d.join(', ');
                }
                else if (nodeContent.optionType === models_1.OptionType.RANKING) {
                    return (_e = nodeContent.options
                        .map((innerOption) => innerOption.content)) === null || _e === void 0 ? void 0 : _e.join(', ');
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.SIGNATURE) {
                return '';
            }
            if (nodeContent.questionType === models_1.QuestionType.UX) {
                return '';
            }
            if (nodeContent.questionType === models_1.QuestionType.TEXT) {
                return questionnaireConsumerFormData.text;
            }
            if (nodeContent.questionType === models_1.QuestionType.RATING) {
                return (_f = questionnaireConsumerFormData.rating) === null || _f === void 0 ? void 0 : _f.toString();
            }
            if (nodeContent.questionType === models_1.QuestionType.MATRIX) {
                let columnMap = {};
                nodeContent.cols.forEach((col) => {
                    columnMap = Object.assign(Object.assign({}, columnMap), { [parseInt(col.index)]: col.content });
                });
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    return (_g = Object.keys(questionnaireConsumerFormData.matrixOptions)
                        .map((entry) => entry +
                        ' - ' +
                        columnMap[questionnaireConsumerFormData.matrixOptions[entry][0]])) === null || _g === void 0 ? void 0 : _g.join('; ');
                }
                else {
                    return (_h = Object.keys(questionnaireConsumerFormData.matrixOptions)
                        .map((entry) => {
                        var _a;
                        return entry +
                            ' - ' + ((_a = questionnaireConsumerFormData.matrixOptions[entry]
                            .map((item) => columnMap[item])) === null || _a === void 0 ? void 0 : _a.join(', '));
                    })) === null || _h === void 0 ? void 0 : _h.join('; ');
                }
            }
        }
        return '';
    });
}
exports.getAnswerForChat = getAnswerForChat;
function getFormAnswerForChat(questionnaireConsumerFormData, nodeContent) {
    var _a;
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const formQuestionsFormData = questionnaireConsumerFormData.formQuestions;
        if (nodeContent.nodeType === models_1.NodeType.FORM && formQuestionsFormData) {
            const formAnswer = {};
            for (let index = 0; index < nodeContent.formItems.length; index++) {
                const formItem = nodeContent.formItems[index];
                if (!formItem.id) {
                    return '';
                }
                let answer = '';
                if (formItem.nodeContent.nodeType === models_1.NodeType.QUESTION &&
                    formItem.nodeContent.questionType === models_1.QuestionType.OPTIONS &&
                    formItem.nodeContent.optionType === models_1.OptionType.RANKING) {
                    answer = (_a = formQuestionsFormData[index].rankingOptions
                        .map((option) => option.content)) === null || _a === void 0 ? void 0 : _a.join(', ');
                }
                else {
                    answer = yield getAnswerForChat(formQuestionsFormData[index], formItem.nodeContent);
                }
                if (answer &&
                    (formItem.nodeContent.nodeType === models_1.NodeType.STATEMENT ||
                        formItem.nodeContent.nodeType === models_1.NodeType.QUESTION)) {
                    formAnswer[formItem.nodeContent.content] = answer;
                }
            }
            return Object.entries(formAnswer)
                .map((entry) => entry[0] + ' - ' + entry[1])
                .join('; ');
        }
        return '';
    });
}
exports.getFormAnswerForChat = getFormAnswerForChat;
function getAnswer(questionnaireConsumerFormData, nodeContent) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        if (nodeContent.nodeType === models_1.NodeType.QUESTION) {
            if (nodeContent.questionType === models_1.QuestionType.OPTIONS) {
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    return {
                        answer: {
                            variableType: models_1.VariableType.DOUBLE,
                            number: questionnaireConsumerFormData.scqOption,
                        },
                    };
                }
                else if (nodeContent.optionType === models_1.OptionType.MULTIPLE) {
                    return {
                        answer: {
                            variableType: models_1.VariableType.LIST_DOUBLE,
                            numbersList: questionnaireConsumerFormData.mcqOptions,
                        },
                    };
                }
                else if (nodeContent.optionType === models_1.OptionType.RANKING) {
                    return {
                        answer: {
                            variableType: models_1.VariableType.LIST_DOUBLE,
                            numbersList: nodeContent.options.map((option) => parseInt(option.index)),
                        },
                    };
                }
            }
            if (nodeContent.questionType === models_1.QuestionType.SIGNATURE) {
                return yield getSignatureAnswerObj(nodeContent, questionnaireConsumerFormData);
            }
            if (nodeContent.questionType === models_1.QuestionType.UX) {
                return yield getUXAnswerObj(nodeContent, questionnaireConsumerFormData);
            }
            if (nodeContent.questionType === models_1.QuestionType.TEXT) {
                return yield getTextAnswerObj(nodeContent, questionnaireConsumerFormData);
            }
            if (nodeContent.questionType === models_1.QuestionType.RATING) {
                return {
                    answer: {
                        variableType: models_1.VariableType.DOUBLE,
                        number: questionnaireConsumerFormData.rating,
                    },
                };
            }
            if (nodeContent.questionType === models_1.QuestionType.MATRIX) {
                const result = { matrixResponse: {} };
                if (nodeContent.optionType === models_1.OptionType.SINGLE) {
                    Object.keys(questionnaireConsumerFormData.matrixOptions).forEach((entry) => {
                        result.matrixResponse = Object.assign(Object.assign({}, result.matrixResponse), { [entry]: {
                                variableType: models_1.VariableType.DOUBLE,
                                number: questionnaireConsumerFormData.matrixOptions[entry][0],
                            } });
                    });
                }
                else {
                    Object.keys(questionnaireConsumerFormData.matrixOptions).forEach((entry) => {
                        result.matrixResponse = Object.assign(Object.assign({}, result.matrixResponse), { [entry]: {
                                variableType: models_1.VariableType.LIST_DOUBLE,
                                numbersList: questionnaireConsumerFormData.matrixOptions[entry],
                            } });
                    });
                }
                return result;
            }
        }
        return undefined;
    });
}
exports.getAnswer = getAnswer;
function getFormAnswer(questionnaireConsumerFormData, nodeContent) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const formQuestionsFormData = questionnaireConsumerFormData.formQuestions;
        if (nodeContent.nodeType === models_1.NodeType.FORM && formQuestionsFormData) {
            const formAnswer = {};
            for (let index = 0; index < nodeContent.formItems.length; index++) {
                const formItem = nodeContent.formItems[index];
                if (!formItem.id) {
                    return;
                }
                let answer;
                if (formItem.nodeContent.nodeType === models_1.NodeType.QUESTION &&
                    formItem.nodeContent.questionType === models_1.QuestionType.OPTIONS &&
                    formItem.nodeContent.optionType === models_1.OptionType.RANKING) {
                    answer = {
                        answer: {
                            variableType: models_1.VariableType.LIST_DOUBLE,
                            numbersList: formQuestionsFormData[index].rankingOptions.map((option) => parseInt(option.index)),
                        },
                    };
                }
                else {
                    answer = yield getAnswer(formQuestionsFormData[index], formItem.nodeContent);
                }
                if (answer) {
                    formAnswer[formItem.id] = answer;
                }
            }
            return formAnswer;
        }
        return undefined;
    });
}
exports.getFormAnswer = getFormAnswer;
function isVariableValid(config) {
    return config.name !== undefined;
}
exports.isVariableValid = isVariableValid;
function getContent(nodeContent) {
    return nodeContent.content;
}
exports.getContent = getContent;
//# sourceMappingURL=consumerUtils.js.map