import { baseUrls } from './config';
const { fashtagBaseUrl, loginUrl, userServiceBaseUrl, questionnaireBaseUrl } = baseUrls;
export const commonUrls = {
    util: {
        uploadFile: (bucketId) => `${fashtagBaseUrl}/utility/upload/${bucketId}`,
        uploadFileQuestionnaire: (bucketId) => `${questionnaireBaseUrl}/utility/upload/${bucketId}`,
    },
    business: {
        // FIXME: [FIXTURES] this is only for fixtures
        getBusinesses: () => `${fashtagBaseUrl}/admin/business`,
        getStores: (businessId) => `${fashtagBaseUrl}/business/${businessId}/all-stores`,
        getStoresWithAssociates: (businessId) => `${fashtagBaseUrl}/business/${businessId}/all-stores-with-associates`,
    },
    login: {
        login: () => loginUrl,
        logout: () => `${userServiceBaseUrl}/logout`,
    },
    questionnaire: {
        getQuestionnaireUser: (emailId) => `${questionnaireBaseUrl}/user/${emailId}`,
    },
};
//# sourceMappingURL=commonUrls.js.map