import { __awaiter } from "tslib";
import React, { useEffect, useRef, useState } from 'react';
import { AudioRecorderError, getAudioRecorder, } from '../../web-media-recorder/audio';
import { Button } from '@material-ui/core';
import { startTimer, useSelector } from '../../utils';
import { Delete, FiberManualRecord, PlayArrow, Stop } from '@material-ui/icons';
import { NotificationType } from '../../stores/NotificationStore';
export const AudioRecorderComponent = (props) => {
    var _a;
    const recorderRef = useRef();
    const [recorder, setRecorderState] = useState();
    const [isWaiting, setWaiting] = useState(false);
    const [error, setError] = useState();
    const [isRecording, setIsRecording] = useState(false);
    const [isPlaying, setPlaying] = useState(false);
    const audioElemRef = useRef(null);
    const [audioRecordingData, setAudioRecordingData] = useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    function stop() {
        if (audioElemRef.current) {
            audioElemRef.current.pause();
            audioElemRef.current.currentTime = 0;
            audioElemRef.current.onended = null;
            setPlaying(false);
        }
    }
    function play() {
        if (audioElemRef.current) {
            audioElemRef.current.play();
            audioElemRef.current.onended = stop;
            setPlaying(true);
        }
    }
    useEffect(() => {
        var _a;
        stop();
        if (props.data !== (audioRecordingData !== null && audioRecordingData !== void 0 ? audioRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, audioRecordingData !== null && audioRecordingData !== void 0 ? audioRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [audioRecordingData]);
    useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            audioRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setAudioRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useAudioErrors(setError);
    useEffect(() => {
        if (error) {
            if (isRecording) {
                recorder === null || recorder === void 0 ? void 0 : recorder.stop();
            }
            setRecorder(undefined);
            setIsRecording(false);
            setAudioRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.stop();
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    function onRetryClicked() {
        setError(undefined);
    }
    function onRecordClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            try {
                const recorder = yield getAudioRecorder();
                setRecorder(recorder);
                recorder.start();
                setIsRecording(true);
                setAudioRecordingData(undefined);
            }
            catch (e) {
                if (e.message.toLowerCase().includes('permission')) {
                    setError(AudioRecorderError.PERMISSION_DENIED);
                }
                else if (e.message.toLowerCase().includes('device not found')) {
                    setError(AudioRecorderError.NOT_SUPPORTED);
                }
                else {
                    setError(AudioRecorderError.UNKNOWN);
                }
            }
            setWaiting(false);
        });
    }
    function onDeleteClicked() {
        setAudioRecordingData(undefined);
    }
    function onStopClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            if (!recorder) {
                return;
            }
            const recordingData = yield recorder.stop();
            setIsRecording(false);
            setRecorder(undefined);
            setAudioRecordingData(recordingData);
            setWaiting(false);
        });
    }
    const pushNotification = useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case AudioRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case AudioRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case AudioRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case AudioRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    const [secondsCounter, setSecondsCounter] = useState(0);
    useEffect(() => {
        if (!isRecording) {
            setSecondsCounter(0);
            return undefined;
        }
        return startTimer((time) => {
            setSecondsCounter(Math.floor(time / 1000));
        }, 500);
    }, [isRecording]);
    const hours = Math.floor(secondsCounter / 3600);
    const minutes = Math.floor(secondsCounter / 60) % 60;
    const seconds = secondsCounter % 60;
    return (React.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        React.createElement("span", { className: 'self-start' }, "Audio"),
        React.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            isRecording && (React.createElement("span", { style: {
                    display: 'inline-block',
                    height: 'auto',
                    width: 'auto',
                    color: undefined,
                } },
                hours > 0 && `${hours.toString().padStart(2, '0')}:`,
                minutes.toString().padStart(2, '0'),
                ":",
                seconds.toString().padStart(2, '0'))),
            !audioRecordingData && (React.createElement(Button, { variant: 'contained', disabled: isWaiting, onClick: !isRecording ? onRecordClicked : onStopClicked }, !isRecording ? React.createElement(FiberManualRecord, null) : React.createElement(Stop, null))),
            audioRecordingData && (React.createElement("div", { className: "flex gap-4 p-4" },
                React.createElement("audio", { className: "hidden", controls: true, ref: audioElemRef, src: audioRecordingData.audioUrl }),
                React.createElement(Button, { variant: "contained", onClick: isPlaying ? stop : play }, isPlaying ? React.createElement(Stop, null) : React.createElement(PlayArrow, null)),
                React.createElement(Button, { variant: "contained", onClick: onDeleteClicked, disabled: isPlaying },
                    React.createElement(Delete, null)))))));
};
//# sourceMappingURL=AudioRecorder.js.map