import React, { createElement, useCallback, useMemo, } from 'react';
import { Redirect, Route, useLocation, } from 'react-router-dom';
import { useSelector } from '../../utils';
function isRenderFunction(value) {
    return typeof value === 'function';
}
export const AuthenticatedRoute = (props) => {
    const { location, component, render, children, path, exact, sensitive, strict, needsAuth, loginRoute, defaultRoute, } = props;
    const routerLocation = useLocation();
    const redirectPath = useMemo(() => {
        const encodedRedirectPath = new URLSearchParams(routerLocation.search).get('redirectPath');
        return encodedRedirectPath && decodeURIComponent(encodedRedirectPath);
    }, [routerLocation.search]);
    const isLoggedIn = useSelector((rootStore) => {
        return rootStore.loginStore.isLoggedIn;
    });
    const actualRender = useCallback((routeComponentProps) => {
        if (children) {
            if (isRenderFunction(children)) {
                return children(routeComponentProps);
            }
            else if (!Array.isArray(children) || children.length > 0) {
                return children;
            }
        }
        if (component) {
            return createElement(component, routeComponentProps);
        }
        if (render) {
            return render(routeComponentProps);
        }
        return null;
    }, [children, component, render]);
    const routerProps = useMemo(() => {
        return {
            location,
            path,
            exact,
            sensitive,
            strict,
        };
    }, [exact, location, path, sensitive, strict]);
    const currentPath = encodeURIComponent(routerLocation.pathname + routerLocation.hash + routerLocation.search);
    if (needsAuth && !isLoggedIn) {
        return React.createElement(Redirect, { to: `${loginRoute}?redirectPath=${currentPath}` });
    }
    else if (routerLocation.pathname === loginRoute && isLoggedIn) {
        return React.createElement(Redirect, { to: redirectPath || defaultRoute });
    }
    return React.createElement(Route, Object.assign({}, routerProps, { render: actualRender }));
};
//# sourceMappingURL=AuthenticatedRoute.js.map