import { ValueWithLabel } from './ConditionBuilder';
export declare enum ConditionBuilderVariableType {
    STRING = "STRING",
    INTEGER = "INTEGER",
    REAL = "REAL",
    BOOLEAN = "BOOLEAN",
    DATE = "DATE",
    TIME = "TIME",
    DATE_TIME = "DATE_TIME",
    IMAGE = "IMAGE",
    VIDEO = "VIDEO",
    LIST_STRING = "LIST_STRING",
    LIST_INTEGER = "LIST_INTEGER",
    LIST_REAL = "LIST_REAL",
    CATEGORY = "CATEGORY",
    CATEGORY_MULTIPLE = "CATEGORY_MULTIPLE",
    CATEGORY_RANKING = "CATEGORY_RANKING"
}
export interface ConditionBuilderVariable {
    variableName: string;
    variableType: ConditionBuilderVariableType;
    displayVariableName: string;
    variablePickerValues?: ValueWithLabel[];
    categoryValues?: string[] | ValueWithLabel[];
    description?: string;
    isCorrectableNodeType?: boolean;
}
export declare type LiteralType = ConditionBuilderVariableType | 'RANGE' | 'DATE_RANGE' | 'RANKING_ORDER' | 'RANKING_POSITION';
