import React, { Fragment } from 'react';
import { ExpressionType } from './utils/Expression';
import { Button, MenuItem, Select } from '@material-ui/core';
import { Conjunction, ConjunctionConfigMap } from './utils/Config';
import { getEmptyGroup, getEmptyRule } from './utils/utils';
import { Delete } from '@material-ui/icons';
import { RuleBuilder } from './RuleBuilder';
import { makeStyles } from '@material-ui/core/styles';
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
const GroupBuilder = (props) => {
    const { expression, onChange, deleteGroup, isDeleteEnabled, variables, } = props;
    const classes = useClasses();
    if (expression === null) {
        return null;
    }
    function onConjunctionChange(event) {
        const conjunction = event.target.value;
        onChange(Object.assign(Object.assign({}, expression), { conjunction }));
    }
    function onAddRule() {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: [...expression.subExpressions, getEmptyRule()] }));
    }
    function onAddGroup() {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: [...expression.subExpressions, getEmptyGroup()] }));
    }
    function onDelete() {
        if (isDeleteEnabled) {
            deleteGroup === null || deleteGroup === void 0 ? void 0 : deleteGroup();
        }
    }
    function onSubExpressionChange(index, subExpression) {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: expression.subExpressions.map((item, itemIndex) => {
                if (index === itemIndex) {
                    return subExpression;
                }
                return item;
            }) }));
    }
    function onSubExpressionDelete(index) {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: expression.subExpressions.filter((item, itemIndex) => {
                return itemIndex !== index;
            }) }));
    }
    const groupConfig = ConjunctionConfigMap[expression.conjunction];
    const isAddAllowed = expression.subExpressions.length < groupConfig.maxExpressions;
    return (React.createElement("div", { className: 'flex flex-col border border-gray-300 rounded-md' },
        React.createElement("div", { className: 'flex gap-4 p-4 bg-gray-100 rounded-md items-center' },
            React.createElement(Button, { variant: 'contained', disabled: !isAddAllowed, onClick: onAddRule }, "Add Rule"),
            React.createElement(Button, { variant: 'contained', disabled: !isAddAllowed, onClick: onAddGroup }, "Add Group"),
            React.createElement(Select, { variant: 'outlined', value: expression.conjunction, onChange: onConjunctionChange, inputProps: { className: classes.selectInput } }, Object.keys(Conjunction).map((item) => {
                const conjunction = item;
                return (React.createElement(MenuItem, { key: conjunction, value: conjunction }, ConjunctionConfigMap[conjunction].label));
            })),
            React.createElement("span", { className: 'flex-grow min-w-0' }),
            isDeleteEnabled && (React.createElement(Button, { variant: 'contained', onClick: onDelete },
                React.createElement(Delete, null)))),
        expression.subExpressions.length > 0 && (React.createElement("div", { className: 'flex gap-4 flex-col p-4' }, expression.subExpressions.map((it, index) => {
            if ((it === null || it === void 0 ? void 0 : it.type) === ExpressionType.GROUP) {
                return (React.createElement(GroupBuilder, { key: index, expression: it, onChange: onSubExpressionChange.bind(undefined, index), isDeleteEnabled: true, deleteGroup: onSubExpressionDelete.bind(undefined, index), variables: variables }));
            }
            if ((it === null || it === void 0 ? void 0 : it.type) === ExpressionType.RULE) {
                return (React.createElement(RuleBuilder, { key: index, expression: it, onChange: onSubExpressionChange.bind(undefined, index), isDeleteEnabled: true, deleteRule: onSubExpressionDelete.bind(undefined, index), variables: variables }));
            }
            return React.createElement(Fragment, { key: index }, null);
        })))));
};
const MemoizedGroupBuilder = React.memo(GroupBuilder);
export { MemoizedGroupBuilder as GroupBuilder };
//# sourceMappingURL=GroupBuilder.js.map