import React from 'react';
import { Button } from '@material-ui/core';
import { Delete } from '@material-ui/icons';
import { RulePartBuilder } from './RulePartBuilder';
import { getNextRuleParts } from './utils/utils';
const RuleBuilder = (props) => {
    const { expression, isDeleteEnabled, deleteRule, onChange, variables, } = props;
    function onDelete() {
        if (isDeleteEnabled) {
            deleteRule === null || deleteRule === void 0 ? void 0 : deleteRule();
        }
    }
    function onRulePartChange(index, part) {
        const newParts = expression.parts.slice(0, index);
        newParts.push(part);
        const newRule = Object.assign(Object.assign({}, expression), { parts: newParts });
        const addedParts = getNextRuleParts(newRule, variables);
        newRule.parts = newRule.parts.concat(addedParts);
        onChange(newRule);
    }
    return (React.createElement("div", { className: 'flex p-4 gap-4 bg-green-100 rounded-md border ' +
            'border-gray-300 items-center' },
        React.createElement("span", { className: 'flex-grow min-w-0 flex gap-4 flex-wrap items-center' }, expression.parts.map((part, index) => {
            return (React.createElement(RulePartBuilder, { key: index, rule: expression, partIndex: index, variables: variables, onChange: onRulePartChange }));
        })),
        isDeleteEnabled && (React.createElement(Button, { variant: 'contained', onClick: onDelete },
            React.createElement(Delete, null)))));
};
const MemoizedRuleBuilder = React.memo(RuleBuilder);
export { MemoizedRuleBuilder as RuleBuilder };
//# sourceMappingURL=RuleBuilder.js.map