import React from 'react';
import { RulePartType } from './utils/RulePart';
import { VariableBuilder } from './part-builders/VariableBuilder';
import { OperatorBuilder } from './part-builders/OperatorBuilder';
import { LiteralBuilder } from './part-builders/LiteralBuilder';
export const RulePartBuilder = (props) => {
    const { rule, onChange, partIndex, variables } = props;
    const part = rule.parts[partIndex];
    switch (part.type) {
        case RulePartType.VARIABLE:
            return (React.createElement(VariableBuilder, { rule: rule, partIndex: partIndex, onChange: onChange, variables: variables }));
        case RulePartType.OPERATOR:
            return (React.createElement(OperatorBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
        case RulePartType.LITERAL:
            return (React.createElement(LiteralBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
    }
};
//# sourceMappingURL=RulePartBuilder.js.map