import React, { useMemo } from 'react';
import { RulePartType } from '../utils/RulePart';
import { Button, ListSubheader, MenuItem, Select, TextField, } from '@material-ui/core';
import { makeStyles } from '@material-ui/core/styles';
import { DatePicker, DateTimePicker, TimePicker } from '@material-ui/pickers';
import { DateRangeBuilder } from './literal-builders/DateRangeBuilder';
import { Add, Close } from '@material-ui/icons';
import { isStringArray } from '../../../utils';
import { ConditionBuilderVariableType } from '../ConditionBuilderVariable';
import { Operator } from '../utils/Config';
import { RankingBuilder } from './literal-builders/RankingBuilder';
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export const LiteralBuilder = (props) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const suggestions = useMemo(() => {
        if (!part.suggestions) {
            return undefined;
        }
        if (isStringArray(part.suggestions)) {
            return part.suggestions.map((it) => ({
                label: it,
                value: it,
            }));
        }
        return part.suggestions.map((it) => it);
    }, [part.suggestions]);
    if (suggestions &&
        part.variableType === ConditionBuilderVariableType.CATEGORY_RANKING) {
        return (React.createElement(RankingBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
    }
    if (suggestions &&
        rule.parts[1].type === RulePartType.OPERATOR && ((_a = rule.parts[1].variable) === null || _a === void 0 ? void 0 : _a.isCorrectableNodeType)) {
        if (rule.parts[1].value === Operator.EQUALS ||
            rule.parts[1].value === Operator.NOT_EQUALS) {
            return (React.createElement(Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) },
                React.createElement(ListSubheader, null, "Options"),
                suggestions.map((it) => (React.createElement(MenuItem, { key: it.value, value: it.value }, it.label))),
                React.createElement(ListSubheader, null, "Truth Value"),
                React.createElement(MenuItem, { key: 'True', value: 'True' }, "True"),
                React.createElement(MenuItem, { key: 'False', value: 'False' }, "False")));
        }
        if (rule.parts[1].value === Operator.EXACTMATCH ||
            rule.parts[1].value === Operator.NOT_EXACTMATCH) {
            return (React.createElement(Select, { value: part.value ? part.value : [], variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { classNasme: classes.selectInput }, onChange: (event) => {
                    var _a;
                    const previousValue = (_a = part.value) !== null && _a !== void 0 ? _a : [];
                    if (previousValue.includes('True') ||
                        previousValue.includes('False')) {
                        onChanged(event.target.value.filter((value) => !previousValue.includes(value)));
                        return;
                    }
                    if (event.target.value.includes('True')) {
                        onChanged(['True']);
                    }
                    else if (event.target.value.includes('False')) {
                        onChanged(['False']);
                    }
                    else {
                        onChanged(event.target.value);
                    }
                } },
                React.createElement(ListSubheader, null, "Options"),
                suggestions.map((it) => (React.createElement(MenuItem, { key: it.value, value: it.value }, it.label))),
                React.createElement(ListSubheader, null, "Truth Value"),
                React.createElement(MenuItem, { key: 'True', value: 'True' }, "True"),
                React.createElement(MenuItem, { key: 'False', value: 'False' }, "False")));
        }
    }
    if (suggestions && !part.multiSelect) {
        return (React.createElement(Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) }, suggestions.map((it) => (React.createElement(MenuItem, { key: it.value, value: it.value }, it.label)))));
    }
    if (suggestions && part.multiSelect) {
        return (React.createElement(Select, { value: part.value ? part.value : [], variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) }, suggestions.map((it) => (React.createElement(MenuItem, { key: it.value, value: it.value }, it.label)))));
    }
    switch (part.literalType) {
        case ConditionBuilderVariableType.STRING:
            return (React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_b = part.value) !== null && _b !== void 0 ? _b : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariableType.VIDEO:
            return (React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_c = part.value) !== null && _c !== void 0 ? _c : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariableType.IMAGE:
            return (React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_d = part.value) !== null && _d !== void 0 ? _d : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariableType.INTEGER:
            return (React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_e = part.value) !== null && _e !== void 0 ? _e : '', onChange: (event) => {
                    const matches = event.target.value.match(/^-?([1-9]?|[1-9][0-9]*)$/);
                    if (!matches) {
                        return;
                    }
                    onChanged(event.target.value);
                } }));
        case ConditionBuilderVariableType.REAL:
            return (React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_f = part.value) !== null && _f !== void 0 ? _f : '', onChange: (event) => {
                    const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                    if (!matches) {
                        return;
                    }
                    onChanged(event.target.value);
                } }));
        case ConditionBuilderVariableType.BOOLEAN:
            return (React.createElement(Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) },
                React.createElement(MenuItem, { value: 'true' }, "Yes"),
                React.createElement(MenuItem, { value: 'false' }, "No")));
        case ConditionBuilderVariableType.DATE:
            return (React.createElement(DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'dd/MM/yyyy', value: (_g = part.value) !== null && _g !== void 0 ? _g : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariableType.TIME:
            return (React.createElement(TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'HH:mm', value: (_h = part.value) !== null && _h !== void 0 ? _h : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariableType.DATE_TIME:
            return (React.createElement(DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'dd/MM/yyyy HH:mm', value: (_j = part.value) !== null && _j !== void 0 ? _j : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariableType.CATEGORY:
            break;
        case 'DATE_RANGE':
            return React.createElement(DateRangeBuilder, Object.assign({}, props));
        case 'RANGE':
            // eslint-disable-next-line
            const value = ((_k = part.value) !== null && _k !== void 0 ? _k : { min: '', max: '', type: 'range' });
            return (React.createElement(React.Fragment, null,
                React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_l = value.min) !== null && _l !== void 0 ? _l : '', onChange: (event) => {
                        const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                        if (!matches) {
                            return;
                        }
                        onChanged(Object.assign(Object.assign({}, value), { min: event.target.value }));
                    } }),
                React.createElement("span", { className: 'flex items-center' }, "-"),
                React.createElement(TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_m = value.max) !== null && _m !== void 0 ? _m : '', onChange: (event) => {
                        const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                        if (!matches) {
                            return;
                        }
                        onChanged(Object.assign(Object.assign({}, value), { max: event.target.value }));
                    } })));
        case ConditionBuilderVariableType.LIST_STRING: {
            const listVal = ((_o = part.value) !== null && _o !== void 0 ? _o : []);
            return (React.createElement(React.Fragment, null,
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (React.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        React.createElement(TextField, { variant: 'outlined', inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => onChanged(listVal.map((it, index) => {
                                if (index === fieldIndex) {
                                    return event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '');
                                }
                                return it;
                            })) }),
                        React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            React.createElement(Close, null)),
                        fieldIndex !== listVal.length - 1 && (React.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                React.createElement(Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    React.createElement(Add, null)),
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
        case ConditionBuilderVariableType.LIST_INTEGER: {
            const listVal = ((_p = part.value) !== null && _p !== void 0 ? _p : []);
            return (React.createElement(React.Fragment, null,
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (React.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        React.createElement(TextField, { variant: 'outlined', key: fieldIndex, inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', onChange: (event) => {
                                const matches = event.target.value.match(/^-?([1-9]?|[1-9][0-9]*)$/);
                                if (!matches) {
                                    return;
                                }
                                onChanged(listVal.map((it, index) => {
                                    if (index === fieldIndex) {
                                        return event.target.value;
                                    }
                                    return it;
                                }));
                            } }),
                        React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            React.createElement(Close, null)),
                        fieldIndex !== listVal.length - 1 && (React.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                React.createElement(Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    React.createElement(Add, null)),
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
        case ConditionBuilderVariableType.LIST_REAL: {
            const listVal = ((_q = part.value) !== null && _q !== void 0 ? _q : []);
            return (React.createElement(React.Fragment, null,
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (React.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        React.createElement(TextField, { variant: 'outlined', key: fieldIndex, inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', onChange: (event) => {
                                const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                                if (!matches) {
                                    return;
                                }
                                onChanged(listVal.map((it, index) => {
                                    if (index === fieldIndex) {
                                        return event.target.value;
                                    }
                                    return it;
                                }));
                            } }),
                        React.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            React.createElement(Close, null)),
                        fieldIndex !== listVal.length - 1 && (React.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                React.createElement(Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    React.createElement(Add, null)),
                React.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
    }
    return React.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=LiteralBuilder.js.map