import React from 'react';
import { MenuItem, Select } from '@material-ui/core';
import { makeStyles } from '@material-ui/core/styles';
import { OperatorConfigMap } from '../utils/OperatorConfigMap';
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export const OperatorBuilder = (props) => {
    var _a;
    const classes = useClasses();
    const { rule, onChange, partIndex } = props;
    const part = rule.parts[partIndex];
    function onOperatorChange(event) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value: event.target.value }));
    }
    return (React.createElement(Select, { variant: 'outlined', value: (_a = part.value) !== null && _a !== void 0 ? _a : null, onChange: onOperatorChange, inputProps: { className: classes.selectInput } }, part.allowedOperators.map((item) => {
        const config = OperatorConfigMap[item];
        return (React.createElement(MenuItem, { key: item, value: item }, config.label));
    })));
};
//# sourceMappingURL=OperatorBuilder.js.map