import React, { useMemo } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { DatePicker, DateTimePicker, TimePicker } from '@material-ui/pickers';
import { ConditionBuilderVariableType } from '../../ConditionBuilderVariable';
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export const DateRangeBuilder = (props) => {
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const value = part.value || undefined;
    const dateValue = useMemo(() => {
        return {
            type: 'range',
            min: (value === null || value === void 0 ? void 0 : value.min) ? new Date(parseInt(value.min)) : null,
            max: (value === null || value === void 0 ? void 0 : value.max) ? new Date(parseInt(value.max)) : null,
        };
    }, [value]);
    switch (part.variableType) {
        case ConditionBuilderVariableType.DATE:
            return (React.createElement(React.Fragment, null,
                ' ',
                React.createElement(DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                React.createElement("span", { className: 'flex items-center' }, "-"),
                React.createElement(DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
        case ConditionBuilderVariableType.TIME:
            return (React.createElement(React.Fragment, null,
                ' ',
                React.createElement(TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'HH:mm', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                React.createElement("span", { className: 'flex items-center' }, "-"),
                React.createElement(TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'HH:mm', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
        case ConditionBuilderVariableType.DATE_TIME:
            return (React.createElement(React.Fragment, null,
                ' ',
                React.createElement(DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy HH:mm', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                React.createElement("span", { className: 'flex items-center' }, "-"),
                React.createElement(DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy HH:mm', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
    }
    return React.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=DateRangeBuilder.js.map