import React, { useCallback, useEffect, useMemo, } from 'react';
import { ConditionBuilderVariableType } from '../../ConditionBuilderVariable';
import { RankingDraggableOption } from './RankingDraggableOption';
import { DndProvider } from 'react-dnd';
import HTML5Backend from 'react-dnd-html5-backend';
import { makeStyles } from '@material-ui/core/styles';
import { MenuItem, Select } from '@material-ui/core';
function isStringArray(value) {
    return (Array.isArray(value) && (value.length === 0 || typeof value[0] === 'string'));
}
const useClasses = makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
export const RankingBuilder = (props) => {
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const { value, suggestions: actualSuggestions = [], literalType } = part;
    const suggestions = useMemo(() => {
        if (isStringArray(actualSuggestions))
            return actualSuggestions.map((it) => ({ value: it, label: it }));
        return actualSuggestions;
    }, [actualSuggestions]);
    const moveOptions = useCallback((from, to) => {
        if (!isStringArray(value)) {
            return;
        }
        const newValue = [...value];
        const item = value[from];
        newValue.splice(from, 1);
        newValue.splice(to, 0, item);
        onChanged(newValue);
    }, 
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [value]);
    useEffect(() => {
        if (literalType === ConditionBuilderVariableType.CATEGORY_RANKING &&
            !value) {
            const newValue = suggestions.map((it) => it.value);
            onChanged(newValue);
        }
        if (literalType === 'RANKING_ORDER' && !value) {
            const newValue = {
                type: 'ranking_order',
                reverse: false,
                option1: '',
                option2: '',
            };
            onChanged(newValue);
        }
        if (literalType === 'RANKING_POSITION' && !value) {
            const newValue = {
                type: 'ranking_position',
                positions: [],
                option: '',
            };
            onChanged(newValue);
        }
        // eslint-disable-next-line
    }, [literalType, suggestions, value]);
    if (!value) {
        return null;
    }
    if (part.literalType === ConditionBuilderVariableType.CATEGORY_RANKING) {
        const convertedVal = value;
        return (React.createElement("div", null,
            React.createElement(DndProvider, { backend: HTML5Backend }, convertedVal.map((optionVal, index) => {
                var _a;
                const suggestion = suggestions.find((suggestion) => suggestion.value === optionVal);
                return (React.createElement(RankingDraggableOption, { key: optionVal, label: (_a = suggestion === null || suggestion === void 0 ? void 0 : suggestion.label) !== null && _a !== void 0 ? _a : optionVal, move: moveOptions, index: index }));
            }))));
    }
    if (part.literalType === 'RANKING_ORDER') {
        const { option1, option2, reverse } = value;
        return (React.createElement(React.Fragment, null,
            React.createElement(Select, { value: option1, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option1: event.target.value })) }, suggestions.map((suggestion) => {
                return (React.createElement(MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            })),
            React.createElement(Select, { value: reverse.toString(), variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { reverse: event.target.value === 'true' })) },
                React.createElement(MenuItem, { value: 'false' }, "before"),
                React.createElement(MenuItem, { value: 'true' }, "after")),
            React.createElement(Select, { value: option2, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option2: event.target.value })) }, suggestions.map((suggestion) => {
                return (React.createElement(MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            }))));
    }
    if (part.literalType === 'RANKING_POSITION') {
        const { option, positions } = value;
        return (React.createElement(React.Fragment, null,
            React.createElement(Select, { value: option, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option: event.target.value })) }, suggestions.map((suggestion) => {
                return (React.createElement(MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            })),
            "at index",
            React.createElement(Select, { value: positions, variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { positions: event.target.value })) }, suggestions.map((_, index) => {
                return (React.createElement(MenuItem, { key: index + 1, value: `${index + 1}` }, index + 1));
            }))));
    }
    return React.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=RankingBuilder.js.map