import React, { useRef } from 'react';
import { useDragSortableItem } from '../../../drag-n-drop/useDragSortableItem';
import { DragIndicator } from '@material-ui/icons';
export const RankingDraggableOption = (props) => {
    const { label, move, index } = props;
    const itemRef = useRef(null);
    const handleRef = useRef(null);
    const isDragging = useDragSortableItem(index, move, itemRef, handleRef, 'RankingDraggableOption');
    return (React.createElement("div", { ref: itemRef, style: { opacity: isDragging ? 0 : 1 } },
        React.createElement("span", { ref: handleRef },
            React.createElement(DragIndicator, null)),
        label));
};
//# sourceMappingURL=RankingDraggableOption.js.map