export declare enum Conjunction {
    AND = "AND",
    OR = "OR"
}
export declare const BLANK_MARKER = "$#blank#$";
export declare const BLANK_CONDITONAL: string;
export interface ConjunctionConfigType {
    minExpressions: number;
    maxExpressions: number;
    getCombinedCondition: (conditions: string[]) => string;
    label: string;
}
export declare const ConjunctionConfigMap: Record<Conjunction, ConjunctionConfigType>;
export declare enum Operator {
    LESSTHAN = "LESSTHAN",
    GREATERTHAN_EQUALS = "GREATERTHAN_EQUALS",
    GREATERTHAN = "GREATERTHAN",
    LESSTHAN_EQUALS = "LESSTHAN_EQUALS",
    EQUALS = "EQUALS",
    NOT_EQUALS = "NOT_EQUALS",
    BELONGS = "BELONGS",
    NOT_BELONGS = "NOT_BELONGS",
    BELONGS_RANGE = "BELONGS_RANGE",
    NOT_BELONGS_RANGE = "NOT_BELONGS_RANGE",
    STARTSWITH = "STARTSWITH",
    NOT_STARTSWITH = "NOT_STARTSWITH",
    ENDSWITH = "ENDSWITH",
    NOT_ENDSWITH = "NOT_ENDSWITH",
    EXACTMATCH = "EXACTMATCH",
    NOT_EXACTMATCH = "NOT_EXACTMATCH",
    ALLMATCH = "ALLMATCH",
    ANYMATCH = "ANYMATCH",
    CONTAINS_STRING = "CONTAINS_STRING",
    NOT_CONTAINS_STRING = "NOT_CONTAINS_STRING",
    CONTAINS_ANY_OF = "CONTAINS_ANY_OF",
    NOT_CONTAINS_ANY_OF = "NOT_CONTAINS_ANY_OF",
    CONTAINS_ALL_OF = "CONTAINS_ALL_OF",
    NOT_CONTAINS_ALL_OF = "NOT_CONTAINS_ALL_OF",
    EXACTEQUAL = "EXACTEQUAL",
    NOT_EXACTEQUAL = "NOT_EXACTEQUAL",
    RANKING_ORDER = "RANKING_ORDER",
    NOT_RANKING_ORDER = "NOT_RANKING_ORDER",
    RANKING_POSITION = "RANKING_POSITION",
    NOT_RANKING_POSITION = "NOT_RANKING_POSITION"
}
export declare const operators: Operator[];
export declare const SpecialCharacters: {
    COMMA: string;
    TO: string;
    WILDCARD: string;
    DOLLAR: string;
    HASH: string;
};
export declare enum VariableType {
    DOUBLE = "DOUBLE",
    STRING = "STRING",
    LIST_DOUBLE = "LIST_DOUBLE",
    LIST_STRING = "LIST_STRING"
}
