import { ConditionBuilderVariableType, } from '../ConditionBuilderVariable';
export function getVariableConversion(variableType) {
    switch (variableType) {
        case ConditionBuilderVariableType.STRING:
            return 'string';
        case ConditionBuilderVariableType.INTEGER:
            return 'number';
        case ConditionBuilderVariableType.REAL:
            return 'number';
        case ConditionBuilderVariableType.BOOLEAN:
            return 'boolean';
        case ConditionBuilderVariableType.DATE:
            return 'date';
        case ConditionBuilderVariableType.TIME:
            return 'date';
        case ConditionBuilderVariableType.DATE_TIME:
            return 'date';
        case ConditionBuilderVariableType.IMAGE:
            return 'string';
        case ConditionBuilderVariableType.VIDEO:
            return 'string';
        case ConditionBuilderVariableType.CATEGORY:
            return 'string';
        case ConditionBuilderVariableType.CATEGORY_MULTIPLE:
            return 'string';
        case ConditionBuilderVariableType.CATEGORY_RANKING:
            return 'string';
        case 'RANGE':
            return undefined;
        case 'DATE_RANGE':
            return undefined;
        case ConditionBuilderVariableType.LIST_STRING:
            return 'string';
        case ConditionBuilderVariableType.LIST_INTEGER:
            return 'number';
        case ConditionBuilderVariableType.LIST_REAL:
            return 'number';
        case 'RANKING_ORDER':
            return undefined; // doesn't matter
        case 'RANKING_POSITION':
            return undefined; // doesn't matter
    }
}
//# sourceMappingURL=getVariableConversion.js.map