import { RulePartType } from './RulePart';
import { getVariableConversion } from './getVariableConversion';
import { operators } from './Config';
import { OperatorConfigMap } from './OperatorConfigMap';
import { isStringArray } from '../../../utils';
import { ConditionBuilderVariableType, } from '../ConditionBuilderVariable';
export function getVariableRulePart(variable) {
    return {
        type: RulePartType.VARIABLE,
        isAnswerBased: false,
        value: variable,
    };
}
export function getOperatorRulePart(operator, variableObj) {
    const allowedOperators = variableObj
        ? operators.filter((operator) => {
            const supportedTypes = OperatorConfigMap[operator].supportedTypes;
            return supportedTypes.includes(variableObj.variableType);
        })
        : [operator];
    return {
        type: RulePartType.OPERATOR,
        value: operator,
        allowedOperators,
        variable: variableObj,
    };
}
// TODO: handle negative numbers
function getLiteralValue(multiSelect, literalType, strRep) {
    var _a, _b;
    if (!strRep) {
        return undefined;
    }
    if (literalType === 'DATE_RANGE' || literalType === 'RANGE') {
        const matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
        const min = (_a = matchIter.next().value) === null || _a === void 0 ? void 0 : _a[0];
        const max = (_b = matchIter.next().value) === null || _b === void 0 ? void 0 : _b[0];
        if (min && max) {
            return { min, max, type: 'range' };
        }
    }
    if (literalType === 'RANKING_ORDER') {
        const split = strRep.split(':');
        return {
            type: 'ranking_order',
            option1: split[0].slice(1, split[0].length - 1),
            option2: split[1].slice(1, split[1].length - 1),
            reverse: false,
        };
    }
    if (literalType === 'RANKING_POSITION') {
        const split = strRep.split(' ');
        const indexStrList = [];
        const matchIter = strRep.matchAll(/[^#]\d+[^#]/g);
        for (const match of matchIter) {
            indexStrList.push(match[0].slice(1, match[0].length - 1));
        }
        return {
            type: 'ranking_position',
            option: split[0].replace(/#/g, ''),
            positions: indexStrList,
        };
    }
    if (multiSelect) {
        let matchIter;
        const stringList = [];
        switch (literalType) {
            case ConditionBuilderVariableType.LIST_STRING:
                matchIter = strRep.matchAll(/#.+?#/g);
                for (const match of matchIter) {
                    stringList.push(match[0].slice(1, match[0].length - 1));
                }
                return stringList;
            case ConditionBuilderVariableType.LIST_INTEGER:
                matchIter = strRep.matchAll(/\d+/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
            case ConditionBuilderVariableType.LIST_REAL:
                matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
            case ConditionBuilderVariableType.CATEGORY_RANKING:
                matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
        }
    }
    else {
        let match;
        switch (literalType) {
            case ConditionBuilderVariableType.STRING:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariableType.CATEGORY:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariableType.VIDEO:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariableType.IMAGE:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariableType.INTEGER:
                match = strRep.match(/\d+/);
                return match ? match[0] : undefined;
            case ConditionBuilderVariableType.REAL:
                match = strRep.match(/\d+(\.\d+)?/);
                return match ? match[0] : undefined;
            case ConditionBuilderVariableType.BOOLEAN:
                return strRep.includes('true') ? 'true' : 'false';
            case ConditionBuilderVariableType.DATE:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
            case ConditionBuilderVariableType.TIME:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
            case ConditionBuilderVariableType.DATE_TIME:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
        }
    }
    return undefined;
}
export function getLiteralRulePart(operatorConfig, variable, strRep) {
    const literalType = operatorConfig.getLiteralType(variable.variableType);
    const multiSelect = literalType.startsWith('LIST') ||
        literalType === ConditionBuilderVariableType.CATEGORY_RANKING;
    const conversion = getVariableConversion(variable.variableType);
    let categoryValues = [];
    if (variable.categoryValues && variable.categoryValues.length > 0) {
        if (isStringArray(variable.categoryValues)) {
            categoryValues = variable.categoryValues.filter((it) => it);
        }
        else {
            categoryValues = variable.categoryValues.filter((it) => it.value);
        }
    }
    return {
        type: RulePartType.LITERAL,
        multiSelect,
        variableType: variable.variableType,
        suggestions: categoryValues.length > 0 ? categoryValues : undefined,
        value: getLiteralValue(multiSelect, literalType, strRep),
        literalType,
        conversion,
    };
}
//# sourceMappingURL=rulePartUtils.js.map