import { RulePart } from './RulePart';
import { Expression, Group, Rule } from './Expression';
import { ConditionBuilderVariable } from '../ConditionBuilderVariable';
export declare function getLiteralStringValue(part: RulePart | undefined): string;
export declare function getRuleCondition(rule: Rule): string;
export declare function getExpressionCondition(expression: Expression): string;
export declare function getNextRuleParts(partialRule: Rule, variables: ConditionBuilderVariable[]): RulePart[];
export declare function getEmptyRule(): Rule;
export declare function getEmptyGroup(): Group;
export declare function convertConditionToExpression(condition: string, variables: ConditionBuilderVariable[]): Group;
export declare function sanitizeExpression(expression: Expression, variables: ConditionBuilderVariable[]): string;
/**
 * This function can be used to get the HTML representation of condition
 * This should only be used when condition builder is not also part of the UI
 * If condition builder is part of the UI, it has a callback which gives the HTML representation
 * Note: This is a costly operation. Don't call in every render. Memoize the result
 * @param condition The backend representation of the condition
 * @param variables List of variables in condition (Keep in mind if all the variables used in condition
 * are not sent, the HTML might not be correct)
 */
export declare function convertConditionToHTML(condition: string, variables: ConditionBuilderVariable[]): string;
export declare function validateExpression(expression: Expression): boolean;
