import React, { useCallback, useState, } from 'react';
import { Button } from 'react-md';
export const CreateItemForm = (props) => {
    var _a, _b;
    const { cancel, createItem, saveDisabled, label, placeholder } = props;
    const cardTitle = (_a = props.cardTitle) !== null && _a !== void 0 ? _a : `Create new ${label}`;
    const id = (_b = props.id) !== null && _b !== void 0 ? _b : `create-new-${label}`;
    const [itemName, setItemName] = useState('');
    const tags = [];
    const addTag = useCallback((tag) => {
        tags.push(tag);
    }, [tags]);
    const onCardSubmit = useCallback((event) => {
        event.preventDefault();
        const name = itemName;
        if (!name) {
            return;
        }
        createItem(name);
    }, [createItem, itemName]);
    const onItemNameChange = useCallback((title) => {
        setItemName(title.toString());
    }, []);
    return (React.createElement("form", { onSubmit: onCardSubmit, style: { width: '100%', padding: 24 } },
        React.createElement("h1", { style: {
                fontSize: 18,
                fontFamily: 'serif',
                fontWeight: 700,
                color: 'black',
            } }, cardTitle),
        React.createElement("div", { style: {
                fontSize: 14,
                fontWeight: 400,
                color: 'rgba(37,41,45,0.5)',
                marginBottom: 4,
            } }, "Questionnaire Name"),
        React.createElement("input", { value: itemName, onChange: (event) => {
                onItemNameChange(event.target.value);
            }, style: {
                width: '100%',
                height: 40,
                color: '#000',
                borderRadius: 4,
                fontWeight: 400,
                border: 'thin solid #ededed',
                overflow: 'hidden',
                padding: '0 0.5em',
                marginBottom: 16,
            }, id: id, name: id, disabled: saveDisabled }),
        React.createElement("div", { style: { padding: 8, float: 'right' }, className: "md-grid" },
            React.createElement(Button, { primary: true, raised: true, disabled: saveDisabled || !itemName || itemName.trim().length == 0, type: 'submit', className: "md-cell" }, "Create"),
            React.createElement(Button, { raised: true, onClick: cancel, className: "md-cell" }, "Cancel"))));
};
//# sourceMappingURL=CreateItemForm.js.map