import { Popover, Button } from '@material-ui/core';
import { AdjustOutlined, ArrowUpward, CheckBoxOutlineBlankOutlined, Delete, Gesture, Highlight, Label, LayersClear, PanoramaVerticalOutlined, RadioButtonUnchecked, Redo, Remove, SelectAll, Settings, TextFields, Undo, } from '@material-ui/icons';
// eslint-disable-next-line
// @ts-ignore
import { SketchField, StampType, Tools } from '@mayrestinpeace/react-sketch';
import React, { useCallback, useState } from 'react';
import { SettingsPopOver } from './SettingsPopOver';
export const DrawingBoard = (props) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let sketchRef = null;
    const { backgroundImage, onImageRecordingChanged } = props;
    const [anchorEl, setAnchorEl] = React.useState(null);
    const handleClose = useCallback(() => {
        setAnchorEl(null);
    }, []);
    const [lineColor, setLineColor] = useState('#000000');
    const [lineWidth, setLineWidth] = useState(4);
    const [opacity, setOpacity] = useState(0.2);
    const [fontSize, setFontSize] = useState(16);
    const [stampType, setStampType] = useState(StampType.Heart);
    const [tool, setSelectedTool] = useState(Tools.Pencil);
    return (React.createElement("div", null,
        React.createElement("div", { style: { display: 'flex', gap: 8 } },
            React.createElement("div", { style: {
                    display: 'flex',
                    flexDirection: 'column',
                    gap: 4,
                    background: '#FFF',
                } },
                React.createElement(SelectAll, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === Tools.Select ? '#0000FF' : 'inherit',
                    }, onClick: () => setSelectedTool(Tools.Select), htmlColor: tool === Tools.Select ? '#FFFFFF' : '#000000' }),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(Gesture, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Pencil ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Pencil ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Pencil) }),
                    tool === Tools.Pencil && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement(PanoramaVerticalOutlined, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === Tools.Rectangle || tool === Tools.Circle
                            ? '#0000FF'
                            : 'inherit',
                    }, htmlColor: tool === Tools.Rectangle || tool === Tools.Circle
                        ? '#FFFFFF'
                        : '#000000', onClick: () => setSelectedTool(Tools.Rectangle) }),
                (tool === Tools.Rectangle || tool === Tools.Circle) && (React.createElement(React.Fragment, null,
                    React.createElement("div", { style: { gap: 4, display: 'flex' } },
                        React.createElement(CheckBoxOutlineBlankOutlined, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                                background: tool === Tools.Rectangle ? '#0000FF' : 'inherit',
                            }, htmlColor: tool === Tools.Rectangle ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Rectangle) }),
                        tool === Tools.Rectangle && (React.createElement(Settings, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                            }, onClick: (event) => 
                            // eslint-disable-next-line
                            // @ts-ignore
                            setAnchorEl(event.currentTarget) }))),
                    React.createElement("div", { style: { gap: 4, display: 'flex' } },
                        React.createElement(RadioButtonUnchecked, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                                background: tool === Tools.Circle ? '#0000FF' : 'inherit',
                            }, htmlColor: tool === Tools.Circle ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Circle) }),
                        tool === Tools.Circle && (React.createElement(Settings, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                            }, onClick: (event) => 
                            // eslint-disable-next-line
                            // @ts-ignore
                            setAnchorEl(event.currentTarget) }))),
                    React.createElement("div", { style: { height: 1, background: '#0000FF', width: '100%' } }))),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(Remove, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Line ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Line ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Line) }),
                    tool === Tools.Line && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(ArrowUpward, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Arrow ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Arrow ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Arrow) }),
                    tool === Tools.Arrow && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(TextFields, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Text ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Text ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Text) }),
                    tool === Tools.Text && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(LayersClear, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Eraser ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Eraser ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Eraser) }),
                    tool === Tools.Eraser && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(Highlight, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Highlighter ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Highlighter ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Highlighter) }),
                    tool === Tools.Highlighter && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement(AdjustOutlined, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === Tools.Select ? '#0000FF' : 'inherit',
                    }, htmlColor: tool === Tools.Select ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Select) }),
                React.createElement("div", { style: { gap: 4, display: 'flex' } },
                    React.createElement(Label, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === Tools.Stamp ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === Tools.Stamp ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(Tools.Stamp) }),
                    tool === Tools.Stamp && (React.createElement(Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                React.createElement(Undo, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        if (sketchRef.canUndo()) {
                            sketchRef.undo();
                        }
                    } }),
                React.createElement(Redo, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        if (sketchRef.canRedo()) {
                            sketchRef.redo();
                        }
                    } }),
                React.createElement(Delete, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        sketchRef.clear();
                        sketchRef.setBackgroundFromDataUrl('');
                    } })),
            React.createElement("div", { style: { position: 'relative', flexGrow: 1, display: 'flex' } },
                React.createElement("img", { src: backgroundImage, style: { position: 'absolute', width: '100%', height: '100%' } }),
                React.createElement(SketchField, { name: "sketch", className: "canvas-area", 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    ref: (c) => (sketchRef = c), lineColor: lineColor, lineWidth: lineWidth, opacity: opacity, backgroundColor: 'transparent', width: backgroundImage ? '100%' : '100vw', height: backgroundImage ? '100%' : '100vh', 
                    // forceValue
                    tool: tool, setTool: setSelectedTool, fontSize: fontSize, stampType: stampType }))),
        React.createElement(Button, { variant: "contained", onClick: () => {
                onImageRecordingChanged === null || onImageRecordingChanged === void 0 ? void 0 : onImageRecordingChanged({ imageDataURL: sketchRef.toDataURL() });
            }, style: { marginTop: 8 } }, "Save"),
        React.createElement(Popover, { open: !!anchorEl, anchorEl: anchorEl, onClose: handleClose, anchorOrigin: {
                vertical: 'bottom',
                horizontal: 'center',
            }, transformOrigin: {
                vertical: 'top',
                horizontal: 'center',
            } },
            React.createElement(SettingsPopOver, { lineColor: lineColor, setLineColor: setLineColor, lineWidth: lineWidth, setLineWidth: setLineWidth, opacity: opacity, setOpacity: setOpacity, fontSize: fontSize, setFontSize: setFontSize, stampType: stampType, setStampType: setStampType, tool: tool, close: () => setAnchorEl(null) }))));
};
//# sourceMappingURL=DrawingBoard.js.map