import React from 'react';
import { arrowSVG, checkSVG, crossSVG, heartSVG, questionSVG, starSVG, } from './Icons';
// eslint-disable-next-line
// @ts-ignore
import { StampType, Tools } from '@mayrestinpeace/react-sketch';
export const SettingsPopOver = (props) => {
    const { fontSize, lineColor, lineWidth, opacity, setFontSize, setLineColor, setLineWidth, setOpacity, setStampType, stampType, tool, close, } = props;
    return (React.createElement("div", { style: {
            display: 'flex',
            padding: 8,
            borderRadius: 4,
            minWidth: 240,
            flexDirection: 'column',
            gap: 12,
        } },
        (tool === Tools.Pencil ||
            tool === Tools.Rectangle ||
            tool === Tools.Circle ||
            tool === Tools.Line ||
            tool === Tools.Arrow ||
            tool === Tools.Eraser ||
            tool === Tools.Highlighter) && (React.createElement("div", { style: { width: '100%' } },
            React.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Line Width"),
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                React.createElement("div", { onClick: () => {
                        setLineWidth(4);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 4 ? '#AAA' : 'inherit',
                    } }, "4"),
                React.createElement("div", { onClick: () => {
                        setLineWidth(8);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 8 ? '#AAA' : 'inherit',
                    } }, "8"),
                React.createElement("div", { onClick: () => {
                        setLineWidth(12);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 12 ? '#AAA' : 'inherit',
                    } }, "12"),
                React.createElement("div", { onClick: () => {
                        setLineWidth(16);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 16 ? '#AAA' : 'inherit',
                    } }, "16")),
            React.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        tool === Tools.Highlighter && (React.createElement("div", { style: { width: '100%' } },
            React.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Opacity"),
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                React.createElement("div", { onClick: () => {
                        setOpacity(0.2);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.2 ? '#AAA' : 'inherit',
                    } }, "20%"),
                React.createElement("div", { onClick: () => {
                        setOpacity(0.4);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.4 ? '#AAA' : 'inherit',
                    } }, "40%"),
                React.createElement("div", { onClick: () => {
                        setOpacity(0.6);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.6 ? '#AAA' : 'inherit',
                    } }, "60%"),
                React.createElement("div", { onClick: () => {
                        setOpacity(0.8);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.8 ? '#AAA' : 'inherit',
                    } }, "80%")),
            React.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        tool === Tools.Text && (React.createElement("div", { style: { width: '100%' } },
            React.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Font Size"),
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                React.createElement("div", { onClick: () => {
                        setFontSize(12);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 12 ? '#AAA' : 'inherit',
                    } }, "12"),
                React.createElement("div", { onClick: () => {
                        setFontSize(16);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 16 ? '#AAA' : 'inherit',
                    } }, "16"),
                React.createElement("div", { onClick: () => {
                        setFontSize(20);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 20 ? '#AAA' : 'inherit',
                    } }, "20"),
                React.createElement("div", { onClick: () => {
                        setFontSize(24);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 24 ? '#AAA' : 'inherit',
                    } }, "24")),
            React.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        (tool === Tools.Pencil ||
            tool === Tools.Rectangle ||
            tool === Tools.Circle ||
            tool === Tools.Line ||
            tool === Tools.Arrow ||
            tool === Tools.Highlighter ||
            tool === Tools.Text) && (React.createElement("div", { style: { width: '100%' } },
            React.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Color"),
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                React.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#000000',
                        outlineWidth: lineColor === '#000000' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#000000');
                        close();
                    } }),
                React.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#FF1918',
                        outlineWidth: lineColor === '#FF1918' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#FF1918');
                        close();
                    } }),
                React.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#FEDE30',
                        outlineWidth: lineColor === '#FEDE30' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#FEDE30');
                        close();
                    } }),
                React.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#83C686',
                        outlineWidth: lineColor === '#83C686' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#83C686');
                        close();
                    } }),
                React.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#2E8CFE',
                        outlineWidth: lineColor === '#2E8CFE' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#2E8CFE');
                        close();
                    } })),
            React.createElement("div", { style: {
                    width: '100%',
                    height: 1,
                    background: '#AAA',
                    marginTop: 4,
                } }))),
        tool === Tools.Stamp && (React.createElement("div", { style: { width: '100%' } },
            React.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Icon"),
            React.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                React.createElement("img", { src: `data:image/svg+xml;utf8,${heartSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Heart ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Heart);
                        close();
                    } }),
                React.createElement("img", { src: `data:image/svg+xml;utf8,${arrowSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Arrow ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Arrow);
                        close();
                    } }),
                React.createElement("img", { src: `data:image/svg+xml;utf8,${starSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Star ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Star);
                        close();
                    } }),
                React.createElement("img", { src: `data:image/svg+xml;utf8,${checkSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Check ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Check);
                        close();
                    } }),
                React.createElement("img", { src: `data:image/svg+xml;utf8,${crossSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Cross ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Cross);
                        close();
                    } }),
                React.createElement("img", { src: `data:image/svg+xml;utf8,${questionSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === StampType.Question ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(StampType.Question);
                        close();
                    } })),
            React.createElement("div", { style: {
                    width: '100%',
                    height: 1,
                    background: '#AAA',
                    marginTop: 4,
                } })))));
};
//# sourceMappingURL=SettingsPopOver.js.map