import { htmlEscape } from '../../utils';
import { CONTENT_VARIABLE_REGEX } from '../../constants';
function getTinyMCE() {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return window.tinyMCE;
}
const questionnaireLinkTag = '<#questionnaire_link>';
function getChip(display, value, title, background = 'green', color = 'white') {
    return `<span data-chip='true' contenteditable="false" data-value="${value}" title="${title}" style="background: ${background};border-radius: 5px;padding: 3px;color: ${color};">${display}</span>`;
}
export function addChips(string, variables) {
    const demoDiv = document.createElement('div');
    return string
        .replace(/<a href="<#questionnaire_link>">[^<>]+<\/a>/, (aStr) => {
        var _a;
        demoDiv.innerHTML = aStr;
        const anchor = demoDiv.children[0];
        const text = anchor === null || anchor === void 0 ? void 0 : anchor.innerText;
        return ((_a = (text &&
            getChip(text, text, 'questionnaire link', '#39796b', 'white'))) !== null && _a !== void 0 ? _a : '');
    })
        .replace(CONTENT_VARIABLE_REGEX, (a) => {
        const variableName = a.substring(2, a.length - 1);
        const variable = variables.find((it) => it.variableName === variableName);
        if (!variable) {
            return a;
        }
        return getChip(variable.displayVariableName, htmlEscape(`<#${variable.variableName}>`), `variable`, '#4f83cc', 'white');
    });
}
export function removeChips(string) {
    const regex = /<span [^<>]+>[^<]+<\/span>/gi;
    const demoDiv = document.createElement('div');
    return string.replace(regex, (spanStr) => {
        var _a, _b, _c;
        demoDiv.innerHTML = spanStr;
        const span = demoDiv.children[0];
        if (((_a = span === null || span === void 0 ? void 0 : span.dataset) === null || _a === void 0 ? void 0 : _a.chip) !== 'true') {
            return spanStr;
        }
        return (_c = (_b = span === null || span === void 0 ? void 0 : span.dataset) === null || _b === void 0 ? void 0 : _b.value) !== null && _c !== void 0 ? _c : '';
    });
}
export function createPlugins(variablesRef, useVariablesPlugin, variablesPluginName, useQuestionnaireLinkPlugin) {
    const tinyMCE = getTinyMCE();
    const PluginManager = tinyMCE.PluginManager;
    if (useQuestionnaireLinkPlugin) {
        PluginManager.add('questionnairelink', function (editor) {
            const openDialog = function (text = '') {
                return editor.windowManager.open({
                    title: 'Insert Questionnaire Link',
                    initialData: { text: text },
                    body: {
                        type: 'panel',
                        items: [
                            {
                                type: 'input',
                                name: 'text',
                                label: 'text',
                            },
                        ],
                    },
                    buttons: [
                        {
                            type: 'cancel',
                            text: 'Close',
                        },
                        {
                            type: 'submit',
                            text: 'Save',
                            primary: true,
                        },
                    ],
                    onSubmit: function (api) {
                        var _a;
                        const data = api.getData();
                        // Insert content when the window form is submitted
                        const text = (_a = data.text) !== null && _a !== void 0 ? _a : 'link';
                        const value = htmlEscape(`<a href="${questionnaireLinkTag}">${text}</a>`);
                        editor.insertContent(getChip(text, value, 'questionnaire link', '#39796b', 'white'));
                        api.close();
                    },
                });
            };
            // Adds a menu item, which can then be included in any menu via the menu/menubar configuration
            editor.ui.registry.addButton('questionnairelink', {
                text: 'Questionnaire Link',
                onAction: function () {
                    const selection = editor.selection;
                    const rng = selection.getRng();
                    const selectionText = rng === null || rng === void 0 ? void 0 : rng.toString();
                    openDialog(selectionText);
                },
            });
            return {
                getMetadata: function () {
                    return {
                        name: 'Questionnaire Link',
                        url: 'https://app.fashtag.info',
                    };
                },
            };
        });
    }
    if (useVariablesPlugin) {
        PluginManager.add('htmleditorvars', function (editor) {
            // Adds a menu item, which can then be included in any menu via the menu/menubar configuration
            editor.ui.registry.addMenuButton('htmleditorvars', {
                text: variablesPluginName,
                fetch: function (callback) {
                    var _a;
                    const variables = variablesRef.current;
                    callback((_a = variables === null || variables === void 0 ? void 0 : variables.map((item) => {
                        return {
                            type: 'menuitem',
                            text: item.displayVariableName,
                            onAction: function () {
                                const content = getChip(item.displayVariableName, htmlEscape(`<#${item.variableName}>`), `variable`, '#4f83cc', 'white');
                                editor.insertContent(content);
                            },
                        };
                    })) !== null && _a !== void 0 ? _a : [
                        {
                            type: 'menuitem',
                            text: 'No Variables',
                            disabled: true,
                        },
                    ]);
                },
            });
            return {
                getMetadata: function () {
                    return {
                        name: 'Questionnaire Variables',
                        url: 'https://app.fashtag.info',
                    };
                },
            };
        });
    }
}
//# sourceMappingURL=plugins.js.map