import { __awaiter } from "tslib";
import React, { useEffect, useRef, useState } from 'react';
import { getImageRecorder, ImageRecorderError, } from '../../web-media-recorder/image';
import { Button } from '@material-ui/core';
import { Camera, Delete, FiberManualRecord } from '@material-ui/icons';
import { useSelector } from '../../utils';
import { NotificationType } from '../../stores/NotificationStore';
export const ImageRecorderComponent = (props) => {
    var _a;
    const recorderRef = useRef();
    const [recorder, setRecorderState] = useState();
    const [isWaiting, setWaiting] = useState(false);
    const [error, setError] = useState();
    const [isRecording, setIsRecording] = useState(false);
    const imageElementRef = useRef(null);
    const previewRef = useRef(null);
    const [imageRecordingData, setImageRecordingData] = useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.cancel();
            }
        };
    }, []);
    useEffect(() => {
        var _a;
        if (props.data !== (imageRecordingData !== null && imageRecordingData !== void 0 ? imageRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, imageRecordingData !== null && imageRecordingData !== void 0 ? imageRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [imageRecordingData]);
    useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            imageRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setImageRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useImagePermissions(setError);
    useEffect(() => {
        if (error) {
            setRecorder(undefined);
            setIsRecording(false);
            setImageRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    function onRetryClicked() {
        setError(undefined);
    }
    function onRecordClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            try {
                if (!previewRef.current)
                    return;
                const recorder = yield getImageRecorder(previewRef.current);
                setRecorder(recorder);
                setIsRecording(true);
                setImageRecordingData(undefined);
            }
            catch (e) {
                if (e.message.toLowerCase().includes('permission')) {
                    setError(ImageRecorderError.PERMISSION_DENIED);
                }
                else if (e.message.toLowerCase().includes('device not found')) {
                    setError(ImageRecorderError.NOT_SUPPORTED);
                }
                else {
                    setError(ImageRecorderError.UNKNOWN);
                }
            }
            setWaiting(false);
        });
    }
    function onDeleteClicked() {
        setImageRecordingData(undefined);
    }
    function onCaptureClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            if (!recorder) {
                return;
            }
            const recordingData = yield recorder.capture();
            setIsRecording(false);
            setRecorder(undefined);
            setImageRecordingData(recordingData);
            setWaiting(false);
        });
    }
    const pushNotification = useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case ImageRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case ImageRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case ImageRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case ImageRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    return (React.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        React.createElement("span", { className: 'self-start' }, "Image"),
        React.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            React.createElement("div", { className: `flex items-stretch relative`, style: {
                    height: isRecording ? 220 : 0,
                    width: isRecording ? 'auto' : 0,
                } },
                React.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, autoPlay: true, muted: true })),
            !imageRecordingData && (React.createElement(Button, { disabled: isWaiting, variant: 'contained', onClick: !isRecording ? onRecordClicked : onCaptureClicked }, !isRecording ? React.createElement(FiberManualRecord, null) : React.createElement(Camera, null))),
            imageRecordingData && (React.createElement("div", { className: "flex items-stretch relative", style: {
                    width: 400,
                    height: 220,
                } },
                React.createElement("img", { className: "flex-grow min-w-0 object-contain ", ref: imageElementRef, src: imageRecordingData.imageUrl }),
                React.createElement("span", { className: "top-0 right-0 absolute" },
                    React.createElement(Button, { variant: "contained", onClick: onDeleteClicked },
                        React.createElement(Delete, null))))))));
};
//# sourceMappingURL=ImageRecorder.js.map