import { useObserver, Observer } from 'mobx-react';
import React, { useCallback } from 'react';
import { Loader } from '../loader/Loader';
export function LoadingComponent(props) {
    const { response: networkResponse, render, component: Component, children, } = props;
    const { data, isLoading, error } = useObserver(() => {
        return {
            data: networkResponse.data,
            isLoading: networkResponse.isLoading,
            error: networkResponse.error,
        };
    });
    const renderFunction = useCallback(() => {
        if (isLoading)
            return React.createElement(Loader, null);
        if (error)
            return React.createElement(React.Fragment, null, "Oops, something went wrong!");
        if (!data)
            return React.createElement(React.Fragment, null);
        if (render)
            return render(data);
        if (children) {
            if (typeof children === 'function') {
                return children(data);
            }
            else {
                return children;
            }
        }
        if (Component)
            return React.createElement(Component, { response: data });
        return React.createElement(React.Fragment, null);
    }, [Component, children, data, error, isLoading, render]);
    return React.createElement(Observer, null, renderFunction);
}
//# sourceMappingURL=LoadingComponent.js.map