import React from 'react';
import { useSelector } from '../../utils';
import { SnackbarProvider, useSnackbar } from 'notistack';
import { NotificationType } from '../../stores/NotificationStore';
import { useObserver } from 'mobx-react';
import uuid from 'uuid';
import { Button } from '@material-ui/core';
const NotificationTypeSnackbarVariantMapping = {
    [NotificationType.WARNING]: 'warning',
    [NotificationType.ERROR]: 'error',
    [NotificationType.SUCCESS]: 'success',
    [NotificationType.INFO]: 'info',
};
const NotificationProvider = (props) => {
    const { notifications, clear } = useSelector((store) => {
        return {
            notifications: store.notificationStore.notifications,
            clear: store.notificationStore.clearQueue,
        };
    });
    const { enqueueSnackbar } = useSnackbar();
    useObserver(() => {
        notifications.forEach((notification) => {
            var _a;
            enqueueSnackbar(notification.message, {
                id: notification.id || uuid.v4(),
                persist: notification.persist,
                variant: notification.type &&
                    NotificationTypeSnackbarVariantMapping[notification.type],
                action: (_a = notification.actionButtons) === null || _a === void 0 ? void 0 : _a.map((actionButton) => {
                    return (React.createElement(Button, { onClick: actionButton.action }, actionButton.label));
                }),
            });
            if (notifications.length > 0) {
                clear();
            }
        });
    });
    return null;
};
const NotificationProviderWrapper = (props) => {
    return (React.createElement(SnackbarProvider, null,
        React.createElement(NotificationProvider, null),
        props.children));
};
export { NotificationProviderWrapper as NotificationProvider };
//# sourceMappingURL=NotificationProvider.js.map