import React, { useEffect, useRef, useState, } from 'react';
import { Button } from 'react-md';
import { UtilityService } from '../../services';
import { getAudio, getImage, getVideo } from './utilities';
import { ResourceType } from '../../models';
import { Button as MuiButton, TextField } from '@material-ui/core';
const MIME_TYPES = {
    [ResourceType.VIDEO]: 'video/*',
    [ResourceType.AUDIO]: 'audio/*',
    [ResourceType.IMAGE]: 'image/*',
};
export const ResourceSelector = (props) => {
    // const [uploading, toChangeToPropsUpload] = useState(false);
    const [urlText, setUrlText] = useState('');
    const fileInputRef = useRef(null);
    useEffect(() => {
        setUrlText('');
    }, [props.value.url]);
    function removeResource() {
        props.onChange({
            isUploading: false,
            url: '',
        });
    }
    function onUrlTextChange(event) {
        const target = event.target;
        setUrlText(target.value);
    }
    function selectUrl() {
        const url = urlText;
        setUrlText('');
        props.onChange({
            isUploading: false,
            url,
        });
    }
    function selectFile(event) {
        if (!props.bucketName) {
            throw new Error('Bucket name not provided');
        }
        const element = event.target;
        const files = element.files;
        if (!files || files.length === 0) {
            return;
        }
        const file = files[0];
        props.onChange({
            isUploading: true,
            url: '',
        });
        UtilityService.uploadFile(file, props.bucketName, props.uploadServiceType)
            .then((response) => {
            props.onChange({
                isUploading: false,
                url: response.url,
            });
        })
            .catch(() => {
            props.onChange({
                isUploading: false,
                url: '',
            });
            alert('error isUploading image');
        });
        element.value = '';
    }
    const type = props.type;
    const mimeType = MIME_TYPES[type];
    function displayResource() {
        switch (type) {
            case ResourceType.IMAGE:
                return getImage(props.value.url);
            case ResourceType.VIDEO:
                return getVideo(props.value.url);
            case ResourceType.AUDIO:
                return getAudio(props.value.url);
        }
    }
    function onTypeChange(event) {
        if (props.onTypeChange) {
            const target = event.target;
            const newType = target.value;
            props.onTypeChange(newType);
        }
    }
    const value = props.value;
    function onFileUploadClicked() {
        var _a;
        (_a = fileInputRef.current) === null || _a === void 0 ? void 0 : _a.click();
    }
    return (React.createElement("div", { className: 'relative h-full', style: { minHeight: 100 } },
        props.value.url && (React.createElement(React.Fragment, null,
            displayResource(),
            props.enableRemoveResource && !props.disabled && (React.createElement(Button, { icon: true, onClick: removeResource, style: {
                    color: 'red',
                    left: 0,
                    position: 'absolute',
                    top: 0,
                    transform: 'scale(0.75)',
                    transformOrigin: '0 0',
                } }, "cancel")))),
        !value.url && (React.createElement(React.Fragment, null,
            value.isUploading && 'loading',
            !value.isUploading && (React.createElement("div", { className: 'flex flex-col', style: props.isValid || props.isValid === undefined
                    ? {}
                    : { border: '2px solid red', borderRadius: '7px' } },
                props.types && props.types.length > 1 && (React.createElement("label", null,
                    "Select Type: \u00A0\u00A0",
                    React.createElement("select", { onChange: onTypeChange, value: type, disabled: props.disabled }, props.types.map((currentType) => (React.createElement("option", { value: currentType, key: currentType }, currentType)))))),
                (!props.types || props.types.length <= 1) && (React.createElement("div", { className: 'text-md p-5' },
                    "Select ",
                    props.type)),
                props.enableUrlInput && (React.createElement("div", { className: 'self-center flex justify-center items-center my-2' },
                    React.createElement("div", { className: 'mx-2' },
                        React.createElement(TextField, { label: 'URL', onChange: onUrlTextChange, disabled: props.disabled, value: urlText, variant: 'outlined' })),
                    React.createElement("div", { className: 'mx-2' },
                        React.createElement(MuiButton, { onClick: selectUrl, variant: 'contained', disableElevation: true, disabled: props.disabled }, "insert")))),
                props.enableFileUpload && (React.createElement("div", { className: 'self-center my-2' },
                    React.createElement("input", { type: "file", accept: mimeType, disabled: props.disabled, onChange: selectFile, className: 'hidden', ref: fileInputRef }),
                    React.createElement(MuiButton, { onClick: onFileUploadClicked, variant: 'contained', disabled: props.disabled, disableElevation: true }, "Upload File"))))))),
        props.delete && !props.value.isUploading && !props.disabled && (React.createElement(Button, { icon: true, onClick: props.delete, style: {
                color: 'red',
                position: 'absolute',
                right: 0,
                top: 0,
                transform: 'scale(0.75)',
                transformOrigin: '100% 0',
            } }, "delete"))));
};
ResourceSelector.defaultProps = {
    enableFileUpload: true,
    enableRemoveResource: true,
    enableUrlInput: true,
};
//# sourceMappingURL=ResourceSelector.js.map