/* eslint-disable react/prop-types */
import React from 'react';
import { Route, Switch, withRouter, } from 'react-router-dom';
import { SegmentedControl } from '../segmented-control/SegmentedControl';
export function RouteBasedSegmentedControlComponent(props) {
    const parentHistory = props.history;
    const parentMatch = props.match;
    function setSelectedTab(tab) {
        parentHistory.push(`${parentMatch.url}/${tab}`);
    }
    return (React.createElement(Switch, null,
        React.createElement(Route, { path: `${parentMatch.url}/:selectedTab?`, render: (renderProps) => {
                const selectedTab = renderProps.match.params.selectedTab;
                return (React.createElement(SegmentedControl, { tabsData: props.tabsData, selectedTab: selectedTab, setSelectedTab: setSelectedTab }));
            } })));
}
export const RouteBasedSegmentedControl = withRouter(RouteBasedSegmentedControlComponent);
//# sourceMappingURL=RouteBasedSegmentedControl.js.map