import React, { useMemo } from 'react';
import styles from './SegmentedControl.module.scss';
import { classNamesWithModules } from '../../utils';
const classNames = classNamesWithModules(styles);
export function SegmentedControl(props) {
    const tabsData = props.tabsData;
    const selectedTab = props.selectedTab;
    const selectedTabData = useMemo(() => tabsData.find((tabData) => tabData.key === selectedTab), [tabsData, selectedTab]);
    if (!selectedTabData && tabsData.length) {
        props.setSelectedTab(tabsData[0].key);
    }
    function changeTab(event) {
        const element = event.target;
        const tab = element.dataset.tab;
        if (!tab)
            return;
        props.setSelectedTab(tab);
    }
    return (React.createElement("div", { className: classNames('center-tabs') },
        React.createElement("div", { className: classNames('header') },
            React.createElement("div", { className: classNames('tabs-container') }, tabsData.map((tabData) => (React.createElement("div", { className: classNames('tab', {
                    'tab--active': tabData.key === selectedTab,
                }), onClick: changeTab, key: tabData.key, "data-tab": tabData.key }, tabData.name))))),
        selectedTabData && (React.createElement("div", { className: classNames('body') }, selectedTabData.body))));
}
//# sourceMappingURL=SegmentedControl.js.map