import * as Sentry from '@sentry/browser';
import { config } from '../../config';
import React, { Component } from 'react';
export class SentryWrapper extends Component {
    constructor(props) {
        super(props);
        this.state = { hasError: false };
        this.recreateTree = this.recreateTree.bind(this);
    }
    componentDidMount() {
        if (!config.isDevelopment) {
            Sentry.init({
                dsn: this.props.dsn,
            });
        }
    }
    componentDidCatch(error, errorInfo) {
        this.setState({ hasError: true });
        if (!config.isDevelopment) {
            Sentry.withScope((scope) => {
                Object.keys(errorInfo).forEach((key) => {
                    scope.setExtra(key, errorInfo[key]);
                });
                Sentry.captureException(error);
            });
        }
    }
    recreateTree() {
        this.setState({ hasError: false });
    }
    submitFeedback() {
        Sentry.showReportDialog();
    }
    render() {
        if (this.state.hasError) {
            return (React.createElement("div", { style: { padding: 10 } },
                config.isDevelopment && (React.createElement(React.Fragment, null,
                    "there is some dev error",
                    React.createElement("button", { onClick: this.recreateTree }, "Recreate Tree"))),
                !config.isDevelopment && (React.createElement(React.Fragment, null,
                    "There has been an error. It has been logged in sentry.",
                    React.createElement("br", null),
                    "Please reload the page. Contact admin in case error persists.",
                    React.createElement("br", null),
                    React.createElement("button", { onClick: this.submitFeedback }, "Report Feedback")))));
        }
        return this.props.children;
    }
}
//# sourceMappingURL=SentryWrapper.js.map