import { __awaiter } from "tslib";
import React, { useEffect, useRef, useState } from 'react';
import { getVideoRecorder, VideoRecorderError, } from '../../web-media-recorder/video';
import { Button } from '@material-ui/core';
import { Delete, FiberManualRecord, Stop } from '@material-ui/icons';
import { startTimer, useSelector } from '../../utils';
import { NotificationType } from '../../stores/NotificationStore';
export const VideoRecorderComponent = (props) => {
    var _a;
    const recorderRef = useRef();
    const [recorder, setRecorderState] = useState();
    const [isWaiting, setWaiting] = useState(false);
    const [error, setError] = useState();
    const [isRecording, setIsRecording] = useState(false);
    const videoElemRef = useRef(null);
    const previewRef = useRef(null);
    const [videoRecordingData, setVideoRecordingData] = useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    function stop() {
        if (videoElemRef.current) {
            videoElemRef.current.pause();
            videoElemRef.current.currentTime = 0;
            videoElemRef.current.onended = null;
        }
    }
    useEffect(() => {
        var _a;
        stop();
        if (props.data !== (videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [videoRecordingData]);
    useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            videoRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setVideoRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useVideoPermissions(setError);
    useEffect(() => {
        if (error) {
            if (isRecording) {
                recorder === null || recorder === void 0 ? void 0 : recorder.stop();
            }
            setRecorder(undefined);
            setIsRecording(false);
            setVideoRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.stop();
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    function onRetryClicked() {
        setError(undefined);
    }
    function onRecordClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            try {
                if (!previewRef.current)
                    return;
                const recorder = yield getVideoRecorder(previewRef.current);
                setRecorder(recorder);
                recorder.start();
                setIsRecording(true);
                setVideoRecordingData(undefined);
            }
            catch (e) {
                if (e.message.toLowerCase().includes('permission')) {
                    setError(VideoRecorderError.PERMISSION_DENIED);
                }
                else if (e.message.toLowerCase().includes('device not found')) {
                    setError(VideoRecorderError.NOT_SUPPORTED);
                }
                else {
                    setError(VideoRecorderError.UNKNOWN);
                }
            }
            setWaiting(false);
        });
    }
    function onDeleteClicked() {
        setVideoRecordingData(undefined);
    }
    function onStopClicked() {
        return __awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            if (!recorder) {
                return;
            }
            const recordingData = yield recorder.stop();
            setIsRecording(false);
            setRecorder(undefined);
            setVideoRecordingData(recordingData);
            setWaiting(false);
        });
    }
    const pushNotification = useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case VideoRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case VideoRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case VideoRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case VideoRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    const [secondsCounter, setSecondsCounter] = useState(0);
    useEffect(() => {
        if (!isRecording) {
            setSecondsCounter(0);
            return undefined;
        }
        return startTimer((time) => {
            setSecondsCounter(Math.floor(time / 1000));
        }, 500);
    }, [isRecording]);
    const hours = Math.floor(secondsCounter / 3600);
    const minutes = Math.floor(secondsCounter / 60) % 60;
    const seconds = secondsCounter % 60;
    return (React.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        React.createElement("span", { className: 'self-start' }, "Video"),
        React.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            isRecording && (React.createElement("span", { style: {
                    display: 'inline-block',
                    height: 'auto',
                    width: 'auto',
                    color: undefined,
                } },
                hours > 0 && `${hours.toString().padStart(2, '0')}:`,
                minutes.toString().padStart(2, '0'),
                ":",
                seconds.toString().padStart(2, '0'))),
            React.createElement("div", { className: `flex items-stretch relative`, style: {
                    height: isRecording ? 220 : 0,
                    width: isRecording ? 400 : 0,
                } },
                React.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, preload: 'auto', autoPlay: true, muted: true })),
            !videoRecordingData && (React.createElement(Button, { variant: 'contained', disabled: isWaiting, onClick: !isRecording ? onRecordClicked : onStopClicked }, !isRecording ? React.createElement(FiberManualRecord, null) : React.createElement(Stop, null))),
            videoRecordingData && (React.createElement("div", { className: "flex items-stretch relative", style: {
                    width: 400,
                    height: 220,
                } },
                React.createElement("video", { className: "flex-grow min-w-0", controls: true, preload: "auto", ref: videoElemRef, src: videoRecordingData.videoUrl }),
                React.createElement("span", { className: "top-0 right-0 absolute" },
                    React.createElement(Button, { variant: "contained", onClick: onDeleteClicked },
                        React.createElement(Delete, null))))))));
};
//# sourceMappingURL=VideoRecorder.js.map