import { config } from './envConfig';
let loginUrl;
let userServiceBaseUrl;
let questionnaireBaseUrl;
let questionnaireConsumerBaseUrl;
let fashtagBaseUrl;
let fashtagAnalyticsBaseUrl;
let universeBaseUrl;
if (config.isKind) {
    let kindBase = '';
    switch (config.runMode) {
        case config.modes.KIND:
            kindBase = `${window.location.protocol}//${window.location.hostname}`;
            break;
        case config.modes.KIND_MOTHERSHIP:
            kindBase = 'http://100.103.25.116';
            break;
    }
    loginUrl = `${kindBase}:5001/api/v0/login`;
    userServiceBaseUrl = `${kindBase}:5001/api/v0`;
    questionnaireBaseUrl = `${kindBase}:5002/api/v1`;
    questionnaireConsumerBaseUrl = `${kindBase}:5002/api/v1`;
    fashtagBaseUrl = `${kindBase}:5004/api/v1`;
    fashtagAnalyticsBaseUrl = `${kindBase}:5007`;
    universeBaseUrl = `${kindBase}:5003/api/v1`;
    // userServiceBaseUrl = `http://100.68.19.44:5554/api/v0`;
    // questionnaireBaseUrl = `http://100.68.19.44:5200/api/v1`;
    // questionnaireConsumerBaseUrl = `http://100.68.19.44:5200/api/v1`;
    // fashtagBaseUrl = `http://100.68.19.44:7000/api/v1`;
    // fashtagAnalyticsBaseUrl = `http://100.68.19.44:5000`;
    // universeBaseUrl = `http://100.68.19.44:5100/api/v1`;
}
else if (config.runMode === 'local') {
    loginUrl = `/*enter_prod_url_here*//login`;
    userServiceBaseUrl = `/*enter_prod_url_here*/:5554/api/v0`;
    questionnaireBaseUrl = `http://localhost:5200/api/v1`;
    questionnaireConsumerBaseUrl = `http://localhost:5200/api/v1`;
    fashtagBaseUrl = `/*enter_prod_url_here*/:7000/api/v1`;
    fashtagAnalyticsBaseUrl = `http://localhost:5200/api/v1`;
    universeBaseUrl = `/*enter_prod_url_here*/:5100/api/v1`;
}
else {
    loginUrl = `/*enter_prod_url_here*//login`;
    userServiceBaseUrl = `/*enter_prod_url_here*/:5554/api/v0`;
    questionnaireBaseUrl = `https://questionnaire-pwsrg3dzoq-el.a.run.app/api/v1`;
    questionnaireConsumerBaseUrl = `https://questionnaire-pwsrg3dzoq-el.a.run.app/api/v1`;
    fashtagBaseUrl = `/*enter_prod_url_here*/:7000/api/v1`;
    fashtagAnalyticsBaseUrl = `https://questionnaire-pwsrg3dzoq-el.a.run.app/api/v1`;
    universeBaseUrl = `/*enter_prod_url_here*/:5100/api/v1`;
}
export const baseUrls = {
    loginUrl,
    questionnaireBaseUrl,
    questionnaireConsumerBaseUrl,
    fashtagBaseUrl,
    universeBaseUrl,
    userServiceBaseUrl,
    fashtagAnalyticsBaseUrl,
};
//# sourceMappingURL=baseUrls.js.map