export var ResourceType;
(function (ResourceType) {
    ResourceType["VIDEO"] = "Video";
    ResourceType["AUDIO"] = "Audio";
    ResourceType["IMAGE"] = "Image";
})(ResourceType || (ResourceType = {}));
export const ResourceTypeMap = Object.freeze({
    IMAGE: ResourceType.IMAGE,
    VIDEO: ResourceType.VIDEO,
    AUDIO: ResourceType.AUDIO,
});
export const ReverseResourceTypeMap = Object.freeze({
    [ResourceType.IMAGE]: 'IMAGE',
    [ResourceType.VIDEO]: 'VIDEO',
    [ResourceType.AUDIO]: 'AUDIO',
});
export var DragDropTypes;
(function (DragDropTypes) {
    DragDropTypes["SLIDE"] = "slide";
    DragDropTypes["SLIDE_OPTION"] = "slide_option";
})(DragDropTypes || (DragDropTypes = {}));
export const HoverType = Object.freeze({
    NONE: 'none',
    TOP: 'top',
    BOTTOM: 'bottom',
});
export var MediaType;
(function (MediaType) {
    MediaType["VIDEO"] = "VIDEO";
    MediaType["IMAGE"] = "IMAGE";
    MediaType["AUDIO"] = "AUDIO";
})(MediaType || (MediaType = {}));
//# sourceMappingURL=CommonEnums.js.map