import { StoreAssociate } from './StoreAssociate';
import { Store } from './Store';
import { Customer } from './Customer';
import { ProductVarient } from './ProductVarient';
import { OfferDTO } from './OfferDTO';
export declare enum OrderType {
    CHECKOUT = "CHECKOUT",
    OMNICHANNEL = "OMNICHANNEL",
    ONLINE = "ONLINE"
}
export declare enum OrderStatus {
    CREATED = "CREATED",
    PAYMENT_PENDING = "PAYMENT_PENDING",
    PAYMENT_COMPLETE = "PAYMENT_COMPLETE",
    PROCESSING = "PROCESSING",
    PARTIALLY_FULFILLED = "PARTIALLY_FULFILLED",
    COMPLETED = "COMPLETED",
    ORDER_CANCELLED = "ORDER_CANCELLED"
}
export declare enum PaymentStatus {
    COMPLETED = "COMPLETED",
    AUTHORIZED = "AUTHORIZED",
    VOIDED = "VOIDED",
    REFUNDED = "REFUNDED",
    CANCELED = "CANCELED",
    FAILED = "FAILED",
    HOLD = "HOLD",
    DECLINED = "DECLINED",
    READ_CARD_ONLY = "READ_CARD_ONLY"
}
export declare enum PaymentMode {
    DEBIT_CARD = "DEBIT_CARD",
    CREDIT_CARD = "CREDIT_CARD",
    NO_PAYMENT = "NO_PAYMENT"
}
export interface Payment {
    externalId: string;
    paymentResponse?: string;
    amountPaid: number;
    transactionRefNo: string;
    paymentMode: PaymentMode;
    paymentStatus: PaymentStatus;
}
export interface OrderItem {
    externalId: string;
    productVarient: ProductVarient;
    amount: number;
    quantity: number;
}
export interface OrderItemBundle {
    externalId: string;
    orderItems: OrderItem[];
    totalAmount: number;
    offer: OfferDTO;
}
export interface Order {
    orderType: OrderType;
    externalId: string;
    fulfillmentStore: Store;
    checkoutOrder: {
        externalId: string;
        totalAmount: number;
        orderItemBundles: OrderItemBundle[];
        consumer: Customer;
        payments: Payment[];
        paymentId?: string;
        orderStatus: OrderStatus;
        message?: string;
        created_at: Date;
        updated_at: Date;
    };
    fulfillmentStoreAssociate: StoreAssociate;
    created_at: Date;
    updated_at: Date;
}
