export declare enum DisplayLogicLevel {
    NODE = "NODE",
    OPTION = "OPTION",
    FORM_ITEM = "FORM_ITEM",
    FORM_ITEM_OPTION = "FORM_ITEM_OPTION"
}
export interface AbstractDisplayLogicQuery {
    displayLogicLevel: DisplayLogicLevel;
}
export interface NodeDisplayLogicQuery extends AbstractDisplayLogicQuery {
    displayLogicLevel: DisplayLogicLevel.NODE;
    nodeId?: string;
}
export interface OptionDisplayLogicQuery extends AbstractDisplayLogicQuery {
    displayLogicLevel: DisplayLogicLevel.OPTION;
    nodeId?: string;
    optionIndex: number;
}
export interface FormItemDisplayLogicQuery extends AbstractDisplayLogicQuery {
    displayLogicLevel: DisplayLogicLevel.FORM_ITEM;
    nodeId?: string;
    formItemId: string;
}
export interface FormItemOptionDisplayLogicQuery extends AbstractDisplayLogicQuery {
    displayLogicLevel: DisplayLogicLevel.FORM_ITEM_OPTION;
    nodeId?: string;
    formItemId: string;
    optionIndex: number;
}
export declare type DisplayLogicQuery = NodeDisplayLogicQuery | OptionDisplayLogicQuery | FormItemDisplayLogicQuery | FormItemOptionDisplayLogicQuery;
