import { ContentVarValueData } from './ContentVarValueData';
import { NodeContent } from './NodeContent';
import { EvalStatus, SessionStatus } from './QuestionnaireEnums';
import { DisplayPosition, DisplayStyle, DisplayType, ChatDistributionSettings } from './QuestionnareDistribution';
import { UserFeedbackResponse } from './UserFeedbackResponse';
export interface QuestionResponseDTO {
    questionnareId: string;
    nodeContent: NodeContent;
    nodeId: string;
    sessionId: string;
    sessionStatus: SessionStatus;
    isSkippable: boolean;
    contentVarValues: Record<string, ContentVarValueData | undefined>;
    score: number;
    evalStatus: EvalStatus;
    isBackAllowed: boolean;
    isForwardAllowed: boolean;
    feedBackResponseDTO: UserFeedbackResponse;
    prepopulatedAnswer?: string;
    formPrepopulatedAnswer?: Record<string, string>;
    customCSS?: string;
    displayType?: DisplayType;
    displayPosition?: DisplayPosition;
    displayAfterTime?: number;
    webURLMatchesString?: string;
    webScrollTillPercentage?: number;
    displayStyle?: DisplayStyle;
    chatDistributionSettings?: ChatDistributionSettings;
}
