import { ContextVariable } from './ContextVarsModel';
import { FlowType } from './QuestionnaireEnums';
import { QuestionnaireMetadata } from './QuestionnaireMetadata';
import { QuestionnaireProperties } from './QuestionnaireProperties';
import { QuestionnareTags } from './QuestionnareTags';
export declare enum TemplateVisibility {
    NONE = "NONE",
    PUBLIC = "PUBLIC",
    WORKSPACE = "WORKSPACE",
    BUSINESS = "BUSINESS"
}
export interface QuestionnaireTemplate {
    isFashtagTemplate?: boolean;
    ownerEntityId?: string;
    templateVisibility?: TemplateVisibility;
    price?: number;
}
export interface Questionnare {
    id: string;
    hasBeenActivatedOnce: boolean;
    description: string;
    workspaceId: string;
    startNodeIds: string[];
    isValid: boolean;
    errorMessages: Record<string, string | undefined>;
    warningMessages: Record<string, string | undefined>;
    metadata: QuestionnaireMetadata;
    isSimpleQuestionnare: boolean;
    mentions: string;
    allContentVars: string[];
    variables: ContextVariable[];
    thresholdedNodes: string[];
    type: FlowType;
    isAnonymous: boolean;
    timer: number;
    tags: QuestionnareTags[];
    questionnaireProperties: QuestionnaireProperties;
    isTemplate?: boolean;
    isFashtagTemplate?: boolean;
    ownerEntityId?: string;
    templateVisibility?: TemplateVisibility;
    price?: number;
}
