export declare enum DistributionType {
    APP_EMBED = "APP_EMBED",
    WEB_EMBED = "WEB_EMBED",
    AUTO_EMAIL = "AUTO_EMAIL",
    AUTO_SMS = "AUTO_SMS",
    MANUAL_EMAIL = "MANUAL_EMAIL",
    COMMON_LINK = "COMMON_LINK",
    MANUAL_SMS = "MANUAL_SMS"
}
export interface QuestionnaireDistributionResponse {
    questionnaireDistribution: QuestionnaireDistribution;
    isEmailEmbedAllowed: false;
}
export interface QuestionnaireDistribution {
    id?: string;
    questionnaireId?: string;
    autoMinThreshold?: number;
    autoMaxThreshold?: number;
    isAppEmbedEnabled?: boolean;
    isWebEmbedEnabled?: boolean;
    isEmailEnabled?: boolean;
    isSMSEnabled?: boolean;
    manualMaxThreshold?: number;
    questionnaireDistributionInstances?: QuestionnaireDistributionInstances[];
    webEmbedScheduler?: QuestionnaireScheduler;
    appEmbedScheduler?: QuestionnaireScheduler;
    autoEmailScheduler?: QuestionnaireScheduler;
    autoSMSScheduler?: QuestionnaireScheduler;
    emailType?: EmailType;
    autoConditional?: string;
    emailSubject?: string;
    emailContent?: string;
    smsContent?: string;
    appEmbedResponses?: number;
    webEmbedResponses?: number;
    emailAutoResponses?: number;
    smsAutoResponses?: number;
    commonLinkResponses?: number;
    emailManualResponses?: number;
    smsManualResponses?: number;
    appEmbedDisplayType?: DisplayType;
    webEmbedDisplayType?: DisplayType;
    appDisplayPosition?: DisplayPosition;
    webDisplayPosition?: DisplayPosition;
    appDisplayAfterTime?: number;
    webDisplayAfterTime?: number;
    webURLMatchesString?: string;
    webScrollTillPercentage?: number;
    displayStyleMap?: Record<DistributionType, DisplayStyle>;
    chatDistributionSettingsMap?: Record<DistributionType, ChatDistributionSettings>;
}
export declare enum DisplayStyle {
    NORMAL = "NORMAL",
    CHAT = "CHAT"
}
export declare enum SchedulerType {
    ONE_TIME = "ONE_TIME",
    RECURRING = "RECURRING"
}
export declare enum SchedulerOneTimeWhen {
    NOW = "NOW",
    AT_A_LATER_DATE = "AT_A_LATER_DATE",
    AFTER_A_TIME_PERIOD = "AFTER_A_TIME_PERIOD"
}
export declare enum EndType {
    NEVER = "NEVER",
    TILL = "TILL",
    AFTER_MAX = "AFTER_MAX"
}
export declare enum EmailType {
    EMBED = "EMBED",
    LINK = "LINK"
}
export declare enum DistributionInstanceType {
    MANUAL_EMAIL = "MANUAL_EMAIL",
    MANUAL_SMS = "MANUAL_SMS"
}
export declare enum DisplayType {
    POPUP = "POPUP",
    BUBBLE = "BUBBLE",
    DIALOG = "DIALOG",
    EMBED = "EMBED",
    SIDE_TAB = "SIDE_TAB",
    FULL_SCREEN = "FULL_SCREEN"
}
export declare enum DisplayPosition {
    BOTTOM_LEFT = "BOTTOM_LEFT",
    BOTTOM_RIGHT = "BOTTOM_RIGHT"
}
export declare enum EmulationSpeed {
    SLOW = "SLOW",
    MEDIUM = "MEDIUM",
    FAST = "FAST"
}
export interface QuestionnaireScheduler {
    schedulerType?: SchedulerType;
    schedulerOneTimeWhen?: SchedulerOneTimeWhen;
    endType?: EndType;
    atALaterDate?: string;
    afterATimePeriodValue?: number;
    afterATimePeriodType?: string;
    startDate?: string;
    endDate?: string;
    endAfterTimes?: number;
    repeatEveryInterval?: string;
    repeatEveryIntervalValue?: number;
    weekRepeatDays?: string[];
    monthRepeatDays?: string[];
    repeatAndSendAtTime?: string;
    monthRecurrencePeriod?: string;
}
export interface QuestionnaireDistributionInstances {
    emailType?: EmailType;
    questionnaireDistributionType?: DistributionInstanceType;
    smsContent?: string;
    emailSubject?: string;
    emailContent?: string;
    distributionContactSet?: QuestionnaireDistributionContactSet;
    questionnaireScheduler?: QuestionnaireScheduler;
    instanceId?: string;
    creationDate?: string;
}
export interface QuestionnaireDistributionContactSet {
    contactTagIds: string[];
    cohortIds: string[];
    contactIds: string[];
}
export interface QuestionnaireSettings {
    apiKey?: string;
    sendgridKey?: string;
    senderEmailAddress?: string;
    twilioKey?: string;
    businessId?: string;
    twilioAccountSID?: string;
    senderPhoneNumber?: string;
}
export interface ChatDistributionSettings {
    avatarURL?: string;
    typingEmulation?: boolean;
    emulationSpeed?: EmulationSpeed;
}
