import { BlockType } from './UniverseEnums';
import { CheckList } from './CheckList';
export interface BaseBlock {
    id: string;
    blockType: BlockType;
    metadata: string | null;
    priorBlockId: string | null;
    nextBlockId: string | null;
    universePageId: string;
    title: string | null;
}
export interface TextBlock extends BaseBlock {
    blockType: BlockType.TEXT;
    content: string;
}
export interface ImageBlock extends BaseBlock {
    blockType: BlockType.IMAGE;
    mediaURL: string | null;
}
export interface VideoBlock extends BaseBlock {
    blockType: BlockType.VIDEO;
    mediaURL: string | null;
    thumbnailURL: string | null;
}
export interface AudioBlock extends BaseBlock {
    blockType: BlockType.AUDIO;
    mediaURL: string | null;
    thumbnailURL: string | null;
}
export interface SurveyBlock extends BaseBlock {
    blockType: BlockType.SURVEY;
    surveyId: string | null;
}
export interface ChecklistBlock extends BaseBlock {
    blockType: BlockType.CHECKLIST;
    checkListId: string | null;
    checklist: CheckList | null | undefined;
}
export interface QuizBlock extends BaseBlock {
    blockType: BlockType.QUIZ;
    quizId: string | null;
}
export declare type Block = TextBlock | ImageBlock | AudioBlock | VideoBlock | SurveyBlock | ChecklistBlock | QuizBlock;
