import { __awaiter } from "tslib";
import { commonUrls } from '../commonUrls';
import { http } from '../utils';
export var UploadServiceType;
(function (UploadServiceType) {
    UploadServiceType[UploadServiceType["FASHTAG"] = 0] = "FASHTAG";
    UploadServiceType[UploadServiceType["QUESTIONNAIRE"] = 1] = "QUESTIONNAIRE";
})(UploadServiceType || (UploadServiceType = {}));
export class UtilityService {
    static uploadFile(file, bucketName, uploadServiceType) {
        return __awaiter(this, void 0, void 0, function* () {
            const formData = new FormData();
            formData.append('file', file);
            return http.post(uploadServiceType === UploadServiceType.FASHTAG
                ? commonUrls.util.uploadFile(bucketName)
                : commonUrls.util.uploadFileQuestionnaire(bucketName), formData);
        });
    }
}
//# sourceMappingURL=UtilityService.js.map