import { __decorate, __metadata } from "tslib";
import { applyNetworkResponse, getDefaultNetworkResponse } from '../utils';
import { BusinessService } from '../services';
import { action, autorun, computed, observable, runInAction } from 'mobx';
export class BusinessStore {
    constructor(loginStore) {
        this.loginStore = loginStore;
        this.storesResponse = getDefaultNetworkResponse();
        this.selectedStoreId = null;
        this.otherStoreId = null;
        this.setSelectedStore = (storeId) => {
            runInAction(() => {
                this.selectedStoreId = storeId;
            });
        };
        autorun(() => this.getStores(this.loginStore.businessId, this.loginStore.isLoggedIn));
        autorun(() => {
            this.otherStoreId = null;
            if (!this.storesResponse.data || this.storesResponse.data.length === 0) {
                this.selectedStoreId = null;
            }
            else {
                this.selectedStoreId = this.storesResponse.data[0].externalId;
            }
            if (!this.storesResponse.data || this.storesResponse.data.length < 2) {
                this.otherStoreId = null;
            }
            else {
                this.otherStoreId = this.storesResponse.data[1].externalId;
            }
        });
    }
    get selectedStore() {
        if (!this.selectedStoreId || !this.storesResponse.data)
            return null;
        return (this.storesResponse.data.find((store) => store.externalId === this.selectedStoreId) || null);
    }
    get otherStore() {
        if (!this.otherStoreId || !this.storesResponse.data)
            return null;
        return (this.storesResponse.data.find((store) => store.externalId === this.otherStoreId) || null);
    }
    setOtherStore(storeId) {
        this.otherStoreId = storeId;
    }
    getStores(businessId, isLoggedIn) {
        if (!isLoggedIn) {
            applyNetworkResponse(this.storesResponse, false, null, false);
            return;
        }
        applyNetworkResponse(this.storesResponse, true, null, false);
        BusinessService.getStores(businessId)
            .then((response) => {
            if (businessId === this.loginStore.businessId) {
                applyNetworkResponse(this.storesResponse, false, response, false);
            }
        })
            .catch((error) => {
            if (businessId === this.loginStore.businessId) {
                applyNetworkResponse(this.storesResponse, false, null, error);
            }
        });
    }
}
__decorate([
    observable,
    __metadata("design:type", Object)
], BusinessStore.prototype, "storesResponse", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], BusinessStore.prototype, "selectedStoreId", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], BusinessStore.prototype, "otherStoreId", void 0);
__decorate([
    computed,
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [])
], BusinessStore.prototype, "selectedStore", null);
__decorate([
    computed,
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [])
], BusinessStore.prototype, "otherStore", null);
__decorate([
    action,
    __metadata("design:type", Object)
], BusinessStore.prototype, "setSelectedStore", void 0);
__decorate([
    action,
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], BusinessStore.prototype, "setOtherStore", null);
//# sourceMappingURL=BusinessStore.js.map